// Custom Jquery Here
jQuery(document).ready(function () {
    "use strict";

    // Navbar Mobile Burger Menu
    jQuery(".mobile-menu-toggler").on("click", function () {
        jQuery(".main-header").removeClass("going-down");
        jQuery("nav .nav-links").addClass("show");
        jQuery("html").addClass("fixed");
        setTimeout(() => jQuery(".main-header").removeClass("going-down"), 10);
    });
    jQuery(".close-nav-menu-btn").on("click", function () {
        jQuery("nav .nav-links").removeClass("show");
        jQuery("html").removeClass("fixed");
    });

    // Mobile Mega Menus
    if (window.innerWidth < 992) {
        jQuery(".nav-links > ul > li.has-dropdown > a").on(
            "click",
            function () {
                jQuery(this).siblings(".dropdown-wrapper").toggle(200);
            }
        );
    }

    // Header Scroll Effects
    jQuery(function () {
        var lastScrollTop = 0,
            delta = 5;
        jQuery(window).scroll(function () {
            var nowScrollTop = jQuery(this).scrollTop();
            if (Math.abs(lastScrollTop - nowScrollTop) >= delta) {
                if (nowScrollTop > lastScrollTop) {
                    jQuery("header").addClass("going-down");
                } else {
                    jQuery("header").removeClass("going-down");
                }
                lastScrollTop = nowScrollTop;
            }
            if (nowScrollTop > 20) {
                jQuery("header").addClass("blur-bg");
            } else {
                jQuery("header").removeClass("blur-bg");
            }
        });
        var nowScrollTop = jQuery(window).scrollTop();
        if (nowScrollTop > 20) {
            jQuery("header").addClass("blur-bg");
        } else {
            jQuery("header").removeClass("blur-bg");
        }
    });

    // Accounts Overview Box
    jQuery(".accounts-wrapper .box").on("click", function () {
        jQuery(this).toggleClass("active");
        jQuery(this).parent().toggleClass("bg-active");
        jQuery(this).siblings(".details").slideToggle(300);
    });

    // Footer Links Collapse
    jQuery(".footer-links .links-box > h6").on("click", function () {
        jQuery(this).toggleClass("open");
        jQuery(this).siblings(".links-collapse").slideToggle(300);
    });

    // Choose Days on Bot Trading
    jQuery('.choose-days span').on('click', function() {
        jQuery('.choose-days span').removeClass('active');
       jQuery(this).addClass('active');
    });

    jQuery('.m-future-bot-float-btn [data-toggle="popover"]').popover({
        placement : 'right',
        trigger : 'manual',
        html : true,
        content : `<div class="m-bot-popover p-3"><img src="/assets/img/bot-trading/bot-02.png" class="img-fluid" alt="M-Future Bot"></div>`
    }).on("mouseenter", function () {
        var _this = this;
        jQuery(this).popover("show");
        jQuery(".popover").on("mouseleave", function () {
            jQuery(_this).popover('hide');
        });
    }).on("mouseleave", function () {
        var _this = this;
        setTimeout(function () {
            if (!jQuery(".popover:hover").length) {
                jQuery(_this).popover("hide");
            }
        }, 300);
    });
});
