<?php include('../../header.php') ?>
    <section class="hero-mini-banner" style="
            background: url(../../assets/img/account-types.png) no-repeat;
            background-size: cover;
            background-position: center;
            ">
        <div class="container">
            <div class="banner-content">
                <h1 class="text-white display-3 font-weight-bold mb-3">
                    Trading Account Types
                </h1>
                <p class="text-white">
                    Wizense offers trading accounts that suits all your trading needs.
                </p>
            </div>
        </div>
    </section>
    

    
    <section class="trading-account-types-section bg-grey-300 theme-padding">
        <div class="container">
            <div class="title text-center limited-width">
                <h2 class="font-weight-bold display-3 mb-4">Trading account overview</h2>
                <p class="text-lead text-grey-500">Our trading account offers a variety of features. Choose the account
                    which is best suited for you.</p>
            </div>
            <div class="cards-wrapper">
                <div class="account-type-card">
                    <div class="top bg-white d-flex align-items-center justify-content-between">
                        <div class="left d-flex align-items-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.5 62C48.3 62 62 48.3 62 31.5C62 14.7 48.3 1 31.5 1C14.7 1 1 14.7 1 31.5C1 48.3 14.7 62 31.5 62Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <mask id="path-2-inside-1_221_5203" fill="white">
                                        <path d="M20 45.3999C23.1 47.9999 27.1 49.4999 31.5 49.4999C35.8 49.4999 39.7 47.9999 42.8 45.4999" />
                                    </mask>
                                    <path d="M18.9718 46.6258C22.3638 49.4707 26.7291 51.0999 31.5 51.0999V47.8999C27.4709 47.8999 23.8362 46.5291 21.0282 44.174L18.9718 46.6258ZM31.5 51.0999C36.183 51.0999 40.4339 49.4635 43.8044 46.7454L41.7956 44.2544C38.9661 46.5363 35.417 47.8999 31.5 47.8999V51.0999Z" fill="url(#paint0_linear_221_5203)" mask="url(#path-2-inside-1_221_5203)" />
                                    <mask id="path-4-inside-2_221_5203" fill="white">
                                        <path d="M46.5001 21.5L45.9001 20.6C42.6001 16.1 37.6001 13.5 31.6001 13.5C25.4001 13.5 19.9001 16.7 16.6001 21.5" />
                                    </mask>
                                    <path d="M45.9001 20.6L47.2314 19.7125L47.2115 19.6827L47.1903 19.6538L45.9001 20.6ZM47.8314 20.6125L47.2314 19.7125L44.5688 21.4875L45.1688 22.3875L47.8314 20.6125ZM47.1903 19.6538C43.5843 14.7365 38.1018 11.9 31.6001 11.9V15.1C37.0984 15.1 41.6159 17.4635 44.6098 21.5462L47.1903 19.6538ZM31.6001 11.9C24.8358 11.9 18.8583 15.3912 15.2816 20.5936L17.9186 22.4064C20.9419 18.0088 25.9644 15.1 31.6001 15.1V11.9Z" fill="url(#paint1_linear_221_5203)" mask="url(#path-4-inside-2_221_5203)" />
                                    <path d="M47.1001 45.5002H15.9001C15.2001 45.5002 14.6001 44.9002 14.6001 44.2002V26.2002H48.4001V44.2002C48.4001 44.9002 47.8001 45.5002 47.1001 45.5002Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M47.1001 21.5H15.9001C15.2001 21.5 14.6001 22.1 14.6001 22.8V26.1H48.4001V22.8C48.4001 22.1 47.8001 21.5 47.1001 21.5Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M26.2002 22.1V18.7C26.2002 18 26.8002 17.5 27.4002 17.5H35.5002C36.2002 17.5 36.7002 18.1 36.7002 18.7V22.1" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32.3 32.2001H30.8C30.3 32.2001 30 31.8001 30 31.4001V26.1001H33.2V31.4001C33.1 31.9001 32.7 32.2001 32.3 32.2001Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M29.3003 34.6001H33.7003" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_221_5203" x1="21.6518" y1="45.3999" x2="40.2709" y2="45.3999" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.03536" stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_221_5203" x1="47.0075" y1="21.5" x2="17.09" y2="21.653" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.03536" stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="text ml-4">
                                <h4 class="text-secondary font-weight-bold display-5">Standard Account</h4>
                            </div>
                        </div>
                        <div class="right">
                            <span class="text-secondary font20">Minimum Deposit: <b>$100</b></span>
                        </div>
                    </div>
                    <div class="middle">
                        <p class="text-grey-500 text-lead">
                            Get access to the financial world with minimum deposit and maximum returns. Standard account
                            is suitable for all kinds of traders.
                        </p>
                    </div>
                    <div class="bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Zero commission
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Spreads 3
                                    </div>
                                </div>
                            </div>
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Swap Free Yes
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Minimum deposit $100
                                    </div>
                                </div>
                            </div>
                            <div class="column text-right">
                                <a href="https://secure.wizensefx.com/" class="btn btn-primary">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="account-type-card">
                    <div class="top bg-white d-flex align-items-center justify-content-between">
                        <div class="left d-flex align-items-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.5 62C48.3 62 62 48.3 62 31.5C62 14.7 48.3 1 31.5 1C14.7 1 1 14.7 1 31.5C1 48.3 14.7 62 31.5 62Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M28.7999 13.6001C20.0999 14.9001 13.3999 22.4001 13.3999 31.5001C13.3999 35.2001 14.4999 38.7001 16.4999 41.6001" stroke="url(#paint0_linear_221_5237)" stroke-width="1.6" />
                                    <path d="M46.2998 21.2001C43.5998 17.2001 39.2998 14.4001 34.2998 13.6001" stroke="url(#paint1_linear_221_5237)" stroke-width="1.6" />
                                    <path d="M16.8999 42.0001C20.0999 46.8001 25.5999 50.0001 31.8999 50.0001C41.8999 50.0001 49.9999 41.9001 49.9999 31.9001C49.9999 28.1001 48.7999 24.5001 46.7999 21.6001" stroke="url(#paint2_linear_221_5237)" stroke-width="1.6" />
                                    <path d="M38.7998 32.3L47.2998 20" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M28 27.7002L35.3 32.9002" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M15.6997 43.1004L24.5997 28.4004" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M37.2997 36.9002C38.7356 36.9002 39.8997 35.7361 39.8997 34.3002C39.8997 32.8643 38.7356 31.7002 37.2997 31.7002C35.8638 31.7002 34.6997 32.8643 34.6997 34.3002C34.6997 35.7361 35.8638 36.9002 37.2997 36.9002Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M25.8998 28.8001C27.3357 28.8001 28.4998 27.636 28.4998 26.2001C28.4998 24.7642 27.3357 23.6001 25.8998 23.6001C24.4639 23.6001 23.2998 24.7642 23.2998 26.2001C23.2998 27.636 24.4639 28.8001 25.8998 28.8001Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M14.3998 47.8001C15.8357 47.8001 16.9998 46.636 16.9998 45.2001C16.9998 43.7642 15.8357 42.6001 14.3998 42.6001C12.9639 42.6001 11.7998 43.7642 11.7998 45.2001C11.7998 46.636 12.9639 47.8001 14.3998 47.8001Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M48.6 20.4002C50.0359 20.4002 51.2 19.2361 51.2 17.8002C51.2 16.3643 50.0359 15.2002 48.6 15.2002C47.1641 15.2002 46 16.3643 46 17.8002C46 19.2361 47.1641 20.4002 48.6 20.4002Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M31.2999 18.9001C29.6999 18.9001 28.3999 17.6001 28.3999 16.0001V12.0001C28.3999 10.4001 29.6999 9.1001 31.2999 9.1001C32.8999 9.1001 34.1999 10.4001 34.1999 12.0001V16.0001C34.1999 17.6001 32.8999 18.9001 31.2999 18.9001Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_221_5237" x1="27.1917" y1="15.3289" x2="8.92103" y2="21.0505" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_221_5237" x1="45.4068" y1="21.2002" x2="33.9661" y2="16.6932" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                        <linearGradient id="paint2_linear_221_5237" x1="17.7723" y1="42.4681" x2="31.1278" y2="14.1991" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="text ml-4">
                                <h4 class="text-secondary font-weight-bold display-5">ECN Zero Account</h4>
                            </div>
                        </div>
                        <div class="right">
                            <span class="text-secondary font20">Minimum Deposit: <b>$100</b></span>
                        </div>
                    </div>
                    <div class="middle">
                        <p class="text-grey-500 text-lead">
                            Siege all the opportunities! Experienced traders looking for lower spreads with larger lots
                            often prefer this account.
                        </p>
                    </div>
                    <div class="bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Swap Free Yes
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Spreads 1.6
                                    </div>
                                </div>
                            </div>
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Zero commission
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Minimum deposit $100
                                    </div>
                                </div>
                            </div>
                            <div class="column text-right">
                                <a href="https://secure.wizensefx.com/" class="btn btn-primary">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="account-type-card">
                    <div class="top bg-white d-flex align-items-center justify-content-between">
                        <div class="left d-flex align-items-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.5 62C48.3 62 62 48.3 62 31.5C62 14.7 48.3 1 31.5 1C14.7 1 1 14.7 1 31.5C1 48.3 14.7 62 31.5 62Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <mask id="path-2-inside-1_221_5277" fill="white">
                                        <path d="M20 45.3999C23.1 47.9999 27.1 49.4999 31.5 49.4999C35.8 49.4999 39.7 47.9999 42.8 45.4999" />
                                    </mask>
                                    <path d="M18.9718 46.6258C22.3638 49.4707 26.7291 51.0999 31.5 51.0999V47.8999C27.4709 47.8999 23.8362 46.5291 21.0282 44.174L18.9718 46.6258ZM31.5 51.0999C36.183 51.0999 40.4339 49.4635 43.8044 46.7454L41.7956 44.2544C38.9661 46.5363 35.417 47.8999 31.5 47.8999V51.0999Z" fill="url(#paint0_linear_221_5277)" mask="url(#path-2-inside-1_221_5277)" />
                                    <mask id="path-4-inside-2_221_5277" fill="white">
                                        <path d="M46.5001 21.5L45.9001 20.6C42.6001 16.1 37.6001 13.5 31.6001 13.5C25.4001 13.5 19.9001 16.7 16.6001 21.5" />
                                    </mask>
                                    <path d="M45.9001 20.6L47.2314 19.7125L47.2115 19.6827L47.1903 19.6538L45.9001 20.6ZM47.8314 20.6125L47.2314 19.7125L44.5688 21.4875L45.1688 22.3875L47.8314 20.6125ZM47.1903 19.6538C43.5843 14.7365 38.1018 11.9 31.6001 11.9V15.1C37.0984 15.1 41.6159 17.4635 44.6098 21.5462L47.1903 19.6538ZM31.6001 11.9C24.8358 11.9 18.8583 15.3912 15.2816 20.5936L17.9186 22.4064C20.9419 18.0088 25.9644 15.1 31.6001 15.1V11.9Z" fill="url(#paint1_linear_221_5277)" mask="url(#path-4-inside-2_221_5277)" />
                                    <path d="M47.1001 45.5002H15.9001C15.2001 45.5002 14.6001 44.9002 14.6001 44.2002V26.2002H48.4001V44.2002C48.4001 44.9002 47.8001 45.5002 47.1001 45.5002Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M47.1001 21.5H15.9001C15.2001 21.5 14.6001 22.1 14.6001 22.8V26.1H48.4001V22.8C48.4001 22.1 47.8001 21.5 47.1001 21.5Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M26.2002 22.1V18.7C26.2002 18 26.8002 17.5 27.4002 17.5H35.5002C36.2002 17.5 36.7002 18.1 36.7002 18.7V22.1" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32.3 32.2001H30.8C30.3 32.2001 30 31.8001 30 31.4001V26.1001H33.2V31.4001C33.1 31.9001 32.7 32.2001 32.3 32.2001Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M29.3003 34.6001H33.7003" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_221_5277" x1="21.6518" y1="45.3999" x2="40.2709" y2="45.3999" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.03536" stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_221_5277" x1="47.0075" y1="21.5" x2="17.09" y2="21.653" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.03536" stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="text ml-4">
                                <h4 class="text-secondary font-weight-bold display-5">ECN Account</h4>
                            </div>
                        </div>
                        <div class="right">
                            <span class="text-secondary font20">Minimum Deposit: <b>$1000</b></span>
                        </div>
                    </div>
                    <div class="middle">
                        <p class="text-grey-500 text-lead">
                            ECN account matches orders and executes accordingly, charging only commission for execution
                            without placing any premium on the raw spread.
                        </p>
                    </div>
                    <div class="bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        $1 fixed per side commission
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Minimum deposit $1000
                                    </div>
                                </div>
                            </div>
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Swap Free Yes
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Spreads 0.8
                                    </div>
                                </div>
                            </div>
                            <div class="column text-right">
                                <a href="https://secure.wizensefx.com/" class="btn btn-primary">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="account-type-card">
                    <div class="top bg-white d-flex align-items-center justify-content-between">
                        <div class="left d-flex align-items-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.5 62C48.3 62 62 48.3 62 31.5C62 14.7 48.3 1 31.5 1C14.7 1 1 14.7 1 31.5C1 48.3 14.7 62 31.5 62Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <mask id="path-2-inside-1_221_5313" fill="white">
                                        <path d="M20 45.3999C23.1 47.9999 27.1 49.4999 31.5 49.4999C35.8 49.4999 39.7 47.9999 42.8 45.4999" />
                                    </mask>
                                    <path d="M18.9718 46.6258C22.3638 49.4707 26.7291 51.0999 31.5 51.0999V47.8999C27.4709 47.8999 23.8362 46.5291 21.0282 44.174L18.9718 46.6258ZM31.5 51.0999C36.183 51.0999 40.4339 49.4635 43.8044 46.7454L41.7956 44.2544C38.9661 46.5363 35.417 47.8999 31.5 47.8999V51.0999Z" fill="url(#paint0_linear_221_5313)" mask="url(#path-2-inside-1_221_5313)" />
                                    <mask id="path-4-inside-2_221_5313" fill="white">
                                        <path d="M46.5001 21.5L45.9001 20.6C42.6001 16.1 37.6001 13.5 31.6001 13.5C25.4001 13.5 19.9001 16.7 16.6001 21.5" />
                                    </mask>
                                    <path d="M45.9001 20.6L47.2314 19.7125L47.2115 19.6827L47.1903 19.6538L45.9001 20.6ZM47.8314 20.6125L47.2314 19.7125L44.5688 21.4875L45.1688 22.3875L47.8314 20.6125ZM47.1903 19.6538C43.5843 14.7365 38.1018 11.9 31.6001 11.9V15.1C37.0984 15.1 41.6159 17.4635 44.6098 21.5462L47.1903 19.6538ZM31.6001 11.9C24.8358 11.9 18.8583 15.3912 15.2816 20.5936L17.9186 22.4064C20.9419 18.0088 25.9644 15.1 31.6001 15.1V11.9Z" fill="url(#paint1_linear_221_5313)" mask="url(#path-4-inside-2_221_5313)" />
                                    <path d="M47.1001 45.5002H15.9001C15.2001 45.5002 14.6001 44.9002 14.6001 44.2002V26.2002H48.4001V44.2002C48.4001 44.9002 47.8001 45.5002 47.1001 45.5002Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M47.1001 21.5H15.9001C15.2001 21.5 14.6001 22.1 14.6001 22.8V26.1H48.4001V22.8C48.4001 22.1 47.8001 21.5 47.1001 21.5Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M26.2002 22.1V18.7C26.2002 18 26.8002 17.5 27.4002 17.5H35.5002C36.2002 17.5 36.7002 18.1 36.7002 18.7V22.1" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32.3 32.2001H30.8C30.3 32.2001 30 31.8001 30 31.4001V26.1001H33.2V31.4001C33.1 31.9001 32.7 32.2001 32.3 32.2001Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M29.3003 34.6001H33.7003" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_221_5313" x1="21.6518" y1="45.3999" x2="40.2709" y2="45.3999" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.03536" stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_221_5313" x1="47.0075" y1="21.5" x2="17.09" y2="21.653" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.03536" stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="text ml-4">
                                <h4 class="text-secondary font-weight-bold display-5">Pro Account</h4>
                            </div>
                        </div>
                        <div class="right">
                            <span class="text-secondary font20">Minimum Deposit: <b>$10,000</b></span>
                        </div>
                    </div>
                    <div class="middle">
                        <p class="text-grey-500 text-lead">
                            Wizense Pro Account gives you the access to trade forex and CFDs with higher leverage
                            ratios. We also offer volume rebates and margin relief.
                        </p>
                    </div>
                    <div class="bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Swap Free Yes
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Spreads 0.3
                                    </div>
                                </div>
                            </div>
                            <div class="column">
                                <div class="mini-box d-flex mb-4 align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        $3 fixed per side commission
                                    </div>
                                </div>
                                <div class="mini-box d-flex align-items-center">
                                    <div class="icon">
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.93262 7.65948L10.3188 13.0456L20.1118 2.43652" stroke="#83d030" stroke-width="2" />
                                            <path d="M17.4477 3.91249C15.7328 2.27695 13.1127 1 10.5558 1C5.27827 1 1 5.27827 1 10.5558C1 12.9553 1.88445 15.1483 3.34513 16.8265C5.09703 18.8393 7.67783 20.1116 10.5558 20.1116C15.8333 20.1116 20.1116 15.8333 20.1116 10.5558C20.1116 9.57378 19.9634 8.62637 19.6883 7.73468" stroke="#C3D0DE" stroke-width="1.6" />
                                        </svg>
                                    </div>
                                    <div class="text ml-4 font-weight-bold font20 text-secondary">
                                        Minimum deposit $10,000
                                    </div>
                                </div>
                            </div>
                            <div class="column text-right">
                                <a href="https://secure.wizensefx.com/" class="btn btn-primary">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="why-choose theme-padding type-2">
        <div class="container">
            <div class="title text-center limited-width">
                <h2 class="font-weight-bold display-3 mb-3 ab-heading">Why Choose Wizense?</h2>
                <p class="font-weight-light text-grey-500 text-lead">
                    Wizense is an internationally trusted representative. Our features eases the trading experience of our
                    clients.
                </p>
            </div>
            <div class="content-box">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                24/7 Customer support
                            </h5>
                            <p class="text-grey-500">
                                Our customer support experts are available for you 24x7.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                Ease of Transactions
                            </h5>
                            <p class="text-grey-500">
                                Experience uninterrupted quick deposits & withdrawals.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                Safety of Funds
                            </h5>
                            <p class="text-grey-500">
                                Maximum protection and data security with negative balance
                                protection.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                Super- Fast trading execution
                            </h5>
                            <p class="text-grey-500">
                                Trade with fast execution, low spreads & handy tools.
                            </p>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
    
<?php include('../../footer.php') ?>


