<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\Event;
use App\Http\Controllers\Api\AdminController;
use App\Repositories\Admin\EventRepository;
use App\Http\Requests\Admin\EventSaveRequest;

class EventController extends AdminController
{
    protected $eventRepository;

    public function __construct(EventRepository $eventRepository)
    {
        parent::__construct();
        $this->eventRepository = $eventRepository;
    }

    public function index()
    {
        $data = $this->eventRepository->getAll();

        return response()->json($data);
    }

    public function getTrash()
    {
        $data = $this->eventRepository->getTrash();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->eventRepository->show($id);

        return response()->json($data);
    }

    public function save(EventSaveRequest $request)
    {
        $this->eventRepository->save($request);

        return response()->noContent();
    }

    public function destroy(Event $event)
    {
        $this->eventRepository->destroy($event);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->eventRepository->restore($id);

        return response()->noContent();
    }
}
