<?php

namespace App\Http\Controllers\Api\General;

use App\Models\Group;
use App\Http\Controllers\Api\GeneralController;
use App\Repositories\General\GroupRepository;
use App\Http\Requests\General\GroupSaveRequest;
use App\Http\Requests\General\GroupSendInvitationRequest;

class GroupController extends GeneralController
{
    protected $groupRepository;

    public function __construct(GroupRepository $groupRepository)
    {
        parent::__construct();
        $this->groupRepository = $groupRepository;
    }

    public function index()
    {
        $data = $this->groupRepository->getAll();

        return response()->json($data);
    }

    public function save(GroupSaveRequest $request)
    {
        $this->groupRepository->save($request);

        return response()->noContent();
    }

    public function show($groupId)
    {
        $data = $this->groupRepository->show($groupId);

        return response()->json($data);
    }

    public function showMembers($groupId)
    {
        $data = $this->groupRepository->showMembers($groupId);

        return response()->json($data);
    }

    public function showInviteUsers($groupId)
    {
        $data = $this->groupRepository->showInviteUsers($groupId);

        return response()->json($data);
    }

    public function sendInvitation(GroupSendInvitationRequest $request)
    {
        $this->groupRepository->sendInvitation($request);

        return response()->noContent();
    }

    public function acceptInvitation($groupId)
    {
        $this->groupRepository->acceptInvitation($groupId);

        return response()->noContent();
    }

    public function ignoreInvitation($groupId)
    {
        $this->groupRepository->ignoreInvitation($groupId);

        return response()->noContent();
    }

    public function join($groupId)
    {
        $this->groupRepository->join($groupId);

        return response()->noContent();
    }

    public function userRequest($groupId)
    {
        $this->groupRepository->userRequest($groupId);

        return response()->noContent();
    }

    public function userCancel($groupId)
    {
        $this->groupRepository->userCancel($groupId);

        return response()->noContent();
    }

    public function userSeen($groupId, $userId)
    {
        $this->groupRepository->userSeen($groupId, $userId);

        return response()->noContent();
    }

    public function userAccept($groupId, $userId)
    {
        $this->groupRepository->userAccept($groupId, $userId);

        return response()->noContent();
    }

    public function userDecline($groupId, $userId)
    {
        $this->groupRepository->userDecline($groupId, $userId);

        return response()->noContent();
    }

    public function userRemove($groupId, $userId)
    {
        $this->groupRepository->userRemove($groupId, $userId);

        return response()->noContent();
    }

    public function leave($groupId)
    {
        $this->groupRepository->leave($groupId);

        return response()->noContent();
    }

    public function postSeen($groupId, $postId)
    {
        $this->groupRepository->postSeen($groupId, $postId);

        return response()->noContent();
    }

    public function postAccept($groupId, $postId)
    {
        $this->groupRepository->postAccept($groupId, $postId);

        return response()->noContent();
    }

    public function postDecline($groupId, $postId)
    {
        $this->groupRepository->postDecline($groupId, $postId);

        return response()->noContent();
    }

    public function postRemove($groupId, $postId)
    {
        $this->groupRepository->postRemove($groupId, $postId);

        return response()->noContent();
    }

    public function destroy(Group $group)
    {
        $this->groupRepository->destroy($group);

        return response()->noContent();
    }
}
