<?php

namespace App\Http\Controllers\Api\General;

use App\Http\Controllers\Api\GeneralController;
use App\Repositories\General\UserRepository;
use App\Http\Requests\General\UserDeleteRequest;

class UserController extends GeneralController
{
    protected $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        parent::__construct();
        $this->userRepository = $userRepository;
    }

    public function show($id)
    {
        $data = $this->userRepository->show($id);

        return response()->json($data);
    }

    public function showCount($id)
    {
        $data = $this->userRepository->showCount($id);

        return response()->json($data);
    }

    public function showCountDetail($id, $type)
    {
        $data = $this->userRepository->showCountDetail($id, $type);

        return response()->json($data);
    }

    public function destroy(UserDeleteRequest $request)
    {
        $this->userRepository->destroy($request);

        return response()->noContent();
    }
}
