<?php

namespace App\Http\Requests\General;

use App\Models\Group;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class GroupSendInvitationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Group::owned()->find($this->input('id'))?->exists();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $group = Group::owned()->protected()->findOrFail($this->input('id'));
        $pendingUsersOrMembers = $group->members()->pluck('users.id')->toArray();

        return [
            'id' => ['required', 'exists:groups,id,deleted_at,NULL'],
            'user_ids' => ['required', 'array', 'min:1'],
            'user_ids.*' => ['required', 'distinct', 'exists:users,id,deleted_at,NULL', Rule::notIn($pendingUsersOrMembers)],
        ];
    }
}
