<?php

namespace App\Models;

use App\Enums\ImageNames;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Image extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'imageable_id',
        'imageable_type',
        'name',
        'path',
        'url',
        'mime_type',
        'file_size',
    ];

    /**
     * Get the parent imageable model.
     */
    public function imageable(): MorphTo
    {
        return $this->morphTo();
    }

    public function scopeProfile($query)
    {
        $query->where('name', ImageNames::PROFILE->value);
    }

    public function scopeCover($query)
    {
        $query->where('name', ImageNames::COVER->value);
    }
}
