<?php

namespace App\Models;

use App\Enums\SettingKey;
use App\Enums\SettingType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Setting extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'label',
        'description',
        'type',
        'options',
        'default_value',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'name' => SettingKey::class,
        'type' => SettingType::class,
    ];

    public function users(): BelongsToMany
    {
        return $this->BelongsToMany(User::class)->withPivot('value')->withTimestamps();
    }
}
