<?php

namespace App\Http\Controllers\Admin;

use App\Models\Announcement;
use App\Http\Controllers\AdminController;
use App\Repositories\Admin\AnnouncementRepository;
use App\Http\Requests\Admin\AnnouncementSaveRequest;

class AnnouncementController extends AdminController
{
    protected $announcementRepository;

    public function __construct(AnnouncementRepository $announcementRepository)
    {
        parent::__construct();
        $this->announcementRepository = $announcementRepository;
    }

    public function index()
    {
        $data = $this->announcementRepository->getAll();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->announcementRepository->show($id);

        return response()->json($data);
    }

    public function save(AnnouncementSaveRequest $request)
    {
        $this->announcementRepository->save($request);

        return response()->noContent();
    }

    public function destroy(Announcement $announcement)
    {
        $this->announcementRepository->destroy($announcement);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->announcementRepository->restore($id);

        return response()->noContent();
    }
}
