<?php

namespace App\Http\Requests\General;

use App\Models\Conversation;
use Illuminate\Foundation\Http\FormRequest;

class ConversationGroupSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if ($this->input('id')) {
            return Conversation::owned()->find($this->input('id'))?->exists();
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['nullable', 'exists:conversations,id,deleted_at,NULL'],
        ];
    }
}
