<?php

namespace App\Http\Requests\General;

use App\Models\Setting;
use App\Enums\SettingType;
use Illuminate\Foundation\Http\FormRequest;

class SettingSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $settings = Setting::all();

        $rules = [];

        foreach ($settings as $setting) {
            $rules[$setting->name->value] = match ($setting->type) {
                SettingType::BOOLEAN => ['required', 'boolean'],
                default => ['required'],
            };
        }

        return $rules;
    }
}
