<?php

namespace Database\Seeders;

use App\Models\Setting;
use App\Enums\SettingKey;
use App\Enums\SettingType;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'id' => 1,
                'name' => SettingKey::NOTIFICATION_GROUP_POSTS,
                'label' => SettingKey::NOTIFICATION_GROUP_POSTS->label(),
                'description' => SettingKey::NOTIFICATION_GROUP_POSTS->description(),
                'type' => SettingType::BOOLEAN,
            ],
            [
                'id' => 2,
                'name' => SettingKey::NOTIFICATION_FRIEND_POSTS,
                'label' => SettingKey::NOTIFICATION_FRIEND_POSTS->label(),
                'description' => SettingKey::NOTIFICATION_FRIEND_POSTS->description(),
                'type' => SettingType::BOOLEAN,
            ],
            [
                'id' => 3,
                'name' => SettingKey::NOTIFICATION_MY_POST_COMMENT,
                'label' => SettingKey::NOTIFICATION_MY_POST_COMMENT->label(),
                'description' => SettingKey::NOTIFICATION_MY_POST_COMMENT->description(),
                'type' => SettingType::BOOLEAN,
            ],
        ];

        foreach ($data as $setting) {
            Setting::updateOrCreate(
                ['id' => $setting['id']],
                [...$setting]
            );
        }
    }
}
