<?php

namespace App\Http\Controllers\General;

use App\Models\User;
use App\Http\Controllers\GeneralController;
use App\Repositories\General\FriendRepository;

class FriendController extends GeneralController
{
    protected $friendRepository;

    public function __construct(FriendRepository $friendRepository)
    {
        parent::__construct();
        $this->friendRepository = $friendRepository;
    }

    public function index()
    {
        $data = $this->friendRepository->getAll();

        return response()->json($data);
    }

    public function add(User $user)
    {
        $this->friendRepository->add($user);

        return response()->noContent();
    }

    public function seen(User $user)
    {
        $this->friendRepository->seen($user);

        return response()->noContent();
    }

    public function accept(User $user)
    {
        $this->friendRepository->accept($user);

        return response()->noContent();
    }

    public function decline(User $user)
    {
        $this->friendRepository->decline($user);

        return response()->noContent();
    }

    public function cancel(User $user)
    {
        $this->friendRepository->cancel($user);

        return response()->noContent();
    }

    public function remove(User $user)
    {
        $this->friendRepository->remove($user);

        return response()->noContent();
    }
}
