<?php

namespace App\Http\Requests\General;

use App\Models\Comment;
use Illuminate\Foundation\Http\FormRequest;

class CommentSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if ($this->input('id')) {
            return Comment::owned()->find($this->input('id'))?->exists();
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['nullable', 'exists:comments,id,deleted_at,NULL'],
            'parent_id' => ['nullable', 'exists:comments,id,deleted_at,NULL'],
            'post_id' => ['required', 'exists:posts,id,deleted_at,NULL'],
            'content' => ['required', 'string', 'max:2000'],
            'images' => ['nullable', 'array'],
            'images.*' => ['image', 'max:10000'],
        ];
    }
}
