<?php

namespace App\Http\Requests\General;

use App\Models\Group;
use App\Enums\GroupType;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class GroupSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if ($this->input('id')) {
            return Group::owned()->find($this->input('id'))?->exists();
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['nullable', 'exists:groups,id,deleted_at,NULL'],
            'profile_image' => ['nullable', Rule::requiredIf($this->input('id') == null), 'image', 'max:10000'],
            'cover_image' => ['nullable', Rule::requiredIf($this->input('id') == null), 'image', 'max:10000'],
            'category_id' => ['nullable', 'exists:categories,id,deleted_at,NULL'],
            'name' => ['required', 'string', 'max:120'],
            'description' => ['required', 'string', 'max:2000'],
            'type' => ['required', Rule::in(GroupType::values())],
        ];
    }
}
