<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Group;
use App\Enums\GroupType;
use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Group>
 */
class GroupFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $user = User::inRandomOrder()->first();
        $groupTypes = GroupType::values();
        $date = now()->subDay(rand(20, 30));

        return [
            'user_id' => $user->id,
            'category_id' => Category::all()->random()->id,
            'name' => fake()->sentence(fake()->numberBetween(1, 4)),
            'description' => fake()->realText(),
            'type' => $groupTypes[fake()->numberBetween(0, count($groupTypes) - 1)],
            'created_at' => $date,
            'updated_at' => $date,
        ];
    }

    /**
     * Configure the model factory.
     */
    public function configure(): static
    {
        return $this->afterCreating(function (Group $group) {
            $group->members()->save($group->user, [
                'is_seen' => true,
                'is_accepted' => true,
            ]);
        });
    }
}
