<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\General\PostController;
use App\Http\Controllers\General\UserController;
use App\Http\Controllers\Auth\PasswordController;
use App\Http\Controllers\General\GroupController;
use App\Http\Controllers\General\FriendController;
use App\Http\Controllers\General\CommentController;
use App\Http\Controllers\General\SettingController;
use App\Http\Controllers\General\CommunityController;
use App\Http\Controllers\General\AnnouncementController;
use App\Http\Controllers\General\ConversationController;
use App\Http\Controllers\General\NotificationController;

Route::get('/', [CommunityController::class, 'index'])->name('community.index');

Route::get('/posts', [PostController::class, 'index'])->name('post.index');
Route::get('/post/{id}', [PostController::class, 'show'])->name('post.show');

Route::get('/user/{id}', [UserController::class, 'show'])->name('user.show');
Route::get('/user/{id}/count', [UserController::class, 'showCount'])->name('user.show.count');

Route::get('announcements', [AnnouncementController::class, 'index'])->name('announcement.index');
Route::get('announcements/{id}', [AnnouncementController::class, 'show'])->name('announcement.show');
Route::middleware(['auth', 'verified', 'can:user'])->group(function () {
    Route::put('password', [PasswordController::class, 'update'])->name('password.update');
    Route::delete('/user/delete', [UserController::class, 'destroy'])->name('user.destroy');

    Route::get('/notifications', [NotificationController::class, 'index'])->name('notification.index');
    Route::post('/notifications/seen/{notificationId}', [NotificationController::class, 'seen'])->name('notification.seen');
    Route::delete('/notifications/delete/{notificationId}', [NotificationController::class, 'destroy'])->name('notification.destroy');

    Route::get('/settings', [SettingController::class, 'index'])->name('setting.index');
    Route::post('/settings', [SettingController::class, 'save'])->name('setting.save');

    Route::get('/friends', [FriendController::class, 'index'])->name('friend.index');
    Route::post('/friends/add/{user}', [FriendController::class, 'add'])->name('friend.add');
    Route::post('/friends/seen/{user}', [FriendController::class, 'seen'])->name('friend.seen');
    Route::post('/friends/accept/{user}', [FriendController::class, 'accept'])->name('friend.accept');
    Route::post('/friends/decline/{user}', [FriendController::class, 'decline'])->name('friend.decline');
    Route::post('/friends/cancel/{user}', [FriendController::class, 'cancel'])->name('friend.cancel');
    Route::delete('/friends/remove/{user}', [FriendController::class, 'remove'])->name('friend.remove');

    Route::get('/messages', [ConversationController::class, 'index'])->name('conversation.index');
    Route::get('/messages/{user}', [ConversationController::class, 'show'])->name('conversation.show');
    Route::post('/messages/{user}/save', [ConversationController::class, 'save'])->name('conversation.save');
    Route::post('/messages/{user}/seen/{messageId}', [ConversationController::class, 'seen'])->name('conversation.seen');
    Route::delete('/messages/{user}/delete/{messageId}', [ConversationController::class, 'deleteMessage'])->name('conversation.message.delete');

    Route::post('/messages/group', [ConversationController::class, 'saveGroup'])->name('conversation.group.save');
    Route::get('/messages/group/{conversationId}', [ConversationController::class, 'showGroup'])->name('conversation.group.show');
    Route::post('/messages/group/{conversationId}/save', [ConversationController::class, 'saveGroupMessage'])->name('conversation.group.message.save');
    Route::post('/messages/group/{conversationId}/seen/{messageId}', [ConversationController::class, 'seenGroup'])->name('conversation.group.seen');
    Route::delete('/messages/group/{conversationId}/delete/{messageId}', [ConversationController::class, 'deleteGroupMessage'])->name('conversation.group.message.delete');

    Route::delete('/messages/delete/{conversationId}', [ConversationController::class, 'deleteConversation'])->name('conversation.delete');

    Route::post('/post', [PostController::class, 'save'])->name('post.save');
    Route::delete('/post/{post}', [PostController::class, 'destroy'])->name('post.destroy');
    Route::put('/post/{id}', [PostController::class, 'restore'])->name('post.restore');
    Route::post('/post/{post}', [PostController::class, 'like'])->name('post.like');

    Route::get('/groups', [GroupController::class, 'index'])->name('group.index');
    Route::post('/group', [GroupController::class, 'save'])->name('group.save');
    Route::post('/group/{groupId}', [GroupController::class, 'show'])->name('group.show');
    Route::post('/group/{groupId}/members', [GroupController::class, 'showMembers'])->name('group.show.members');
    Route::post('/group/{groupId}/join', [GroupController::class, 'join'])->name('group.user.join');
    Route::post('/group/{groupId}/request', [GroupController::class, 'userRequest'])->name('group.user.request');
    Route::post('/group/{groupId}/cancel', [GroupController::class, 'userCancel'])->name('group.user.cancel');
    Route::post('/group/{groupId}/user-request/{userId}/seen', [GroupController::class, 'userSeen'])->name('group.user.seen');
    Route::post('/group/{groupId}/user-accept/{userId}', [GroupController::class, 'userAccept'])->name('group.user.accept');
    Route::post('/group/{groupId}/user-decline/{userId}', [GroupController::class, 'userDecline'])->name('group.user.decline');
    Route::post('/group/{groupId}/user-remove/{userId}', [GroupController::class, 'userRemove'])->name('group.user.remove');
    Route::post('/group/{groupId}/leave', [GroupController::class, 'leave'])->name('group.user.leave');
    Route::post('/group/{groupId}/post-request/{postId}/seen', [GroupController::class, 'postSeen'])->name('group.post.seen');
    Route::post('/group/{groupId}/post-accept/{postId}', [GroupController::class, 'postAccept'])->name('group.post.accept');
    Route::post('/group/{groupId}/post-decline/{postId}', [GroupController::class, 'postDecline'])->name('group.post.decline');
    Route::post('/group/{groupId}/post-remove/{postId}', [GroupController::class, 'postRemove'])->name('group.post.remove');
    Route::delete('/group/{groupId}', [GroupController::class, 'destroy'])->name('group.destroy');

    Route::post('/comment', [CommentController::class, 'save'])->name('comment.save');
    Route::delete('/comment/{comment}', [CommentController::class, 'destroy'])->name('comment.destroy');
    Route::post('/comment/{comment}', [CommentController::class, 'like'])->name('comment.like');
});
