$.fn.extend({
    _tabs: function(options) {
        var myObj = {
            eventsArr    : options.eventsArr
        };

        $(this).each(function() {
            for (eventObj in myObj.eventsArr) {
            	if(!$(this).is('.selected')) {
            		$(this).bind(myObj.eventsArr[eventObj].eventType,
            				function(){myObj.eventsArr[eventObj].eventFunc(this);});
            	}
            }
        });
    },

  _FXresizeImg: function(imageObject, aObject) {
    this.imageObject = imageObject;
    this.aObject = aObject;
    this.status = false;
    this.widht = this.imageObject.attr('width');
    this.height = this.imageObject.attr('height');

    this.imgToggle = function(){
      if (!this.status)
      {
        this.imageObject.removeAttr('width'); 
        this.imageObject.removeAttr('height');
        this.imageObject.css('max-width', '779px');
        this.aObject.removeClass('zoomIcon');
        this.aObject.addClass('zoomoutIcon');
        $(this).css('z-index', '10000');
        $(this).css('position', 'relative');
      }
      else
      {
        this.imageObject.attr('width', this.widht); 
        this.imageObject.attr('height', this.height);
        this.imageObject.css('max-width', '452px');
        this.aObject.addClass('zoomIcon');
        this.aObject.removeClass('zoomoutIcon');
        $(this).removeAttr('style'); 
      }
      this.status = !this.status;
    };
    return this;
    }
}); 


var technicalSummaryToolTabObject = 
{
  eventsArr : new Array(
  {
    eventType : 'click',
    eventFunc : function(childObj){
  	  changeTechSummaryTabContent(childObj);
            } 
    })
};

$('#quotesBoxWithTabsTop li')._tabs(technicalSummaryToolTabObject);

function changeTechSummaryTabContent(childObj){

	  $(childObj).unbind('click');
	  $(childObj).addClass('selected').siblings().each(function(){
		  if($(this).is('.selected')) {
				$(this).bind('click',function()
						{ changeTechSummaryTabContent(this); }
				);
			}
	    $(this).removeClass('selected');
	    var id = ($(this).attr('id'));
	    $('#' + id + '_inner').removeClass('displayBlock');
	    $('#' + id + '_inner').addClass('displayNone');
	  });
	  var id = ($(childObj).attr('id'));
	  $('#' + id + '_inner').removeClass('displayNone');
	  $('#' + id + '_inner').addClass('displayBlock');

	  var pair_ID = $('#' + id + '_inner').attr('pair_ID');
	  investingTechSummaryBox.hoveredPair_ID = pair_ID;
	  investingTechSummaryBox.refresher(false);	
	  $("table[table=pairTable] tr").removeClass('selected');
	  $('#'+pair_ID).addClass('selected');
}

	var investingTechSummaryBox = {
		hoveredPair_ID 	: 0,
		pairList		: {forex: new Array(), commodities: new Array(), indices: new Array(), stocks: new Array() },
		updateTool 		: function (val){
							var url_param = '';
							if (location.search) {
							    var parts = location.search.substring(1).split('&');
							    for (var i = 0; i < parts.length; i++) {
							    	var nv = parts[i].split('=');
							        if (!nv[0] || nv[0] == 'referer' || nv[0] == 'timeframe' || nv[0] == 'selectedTabId') continue;

							        url_param += '&' + parts[i];
							    }
							}		
							// check the selected tab
							if($('#referer').html() && $('#referer').html()!=' ') {
								url_param += '&referer=' +$('#referer').html(); 
							}
							var selectedTabId = $('#quotesBoxWithTabsTop li.selected').attr('id');
							url_param += '&selectedTabId=' + selectedTabId;												
							location.replace( '/index.php?timeframe=' + val + url_param);
		},
		 
		 refresher 		: function(recursive){
							ajax_delay = 45000;
							// check which selected tab ******
							var tab_id = 'QBS_1';
							var pairs = '';
							$('#quotesBoxWithTabsTop li').each(function(){
								if ($(this).is('.selected')){
								 	tab_id = $(this).attr('id');
								}
							});
							
							// get pair list
							$('#'+tab_id+'_inner table tr').each(function(){
							 	if (investingTechSummaryBox.hoveredPair_ID == 0)
							 		investingTechSummaryBox.hoveredPair_ID = $(this).attr('id');
								pairs += (pairs) ? ','+$(this).attr('id') : $(this).attr('id');
							});
					
							//get the timeframe
							var timeframe = $('#timeframe').val();

							var lang_ID = $('body').attr('lang_ID');
							if (lang_ID){
								lang_ID = '&lang='+lang_ID;
							}else{
								lang_ID = '';
							}
							
							$.ajax({
								url:'api.php', 
								type: "GET",
								data: "action=refresher&pairs="+pairs+'&timeframe='+timeframe + lang_ID,
								dataType: "text",
								success:
								    function(data) {
										if (data.length > 0) {
											var pairs = JSON.parse(data);
											for (pair_ID in pairs){
												var pairData = pairs[pair_ID];
	
												if (pair_ID == 'time'){
	
													$('#updateTime').html(pairData);
												}else{
													$('#'+pair_ID+' td:nth-child(4)').html(pairData['row']['last']);
													$('#'+pair_ID+' td:nth-child(5)').html(pairData['row']['ma']).removeClass('greenFont redFont neutralFont').addClass(pairData['row']['ma_class']);
													//$('#'+pair_ID+' td:nth-child(4)').attr('class', pairData['row']['ma_class']);
													$('#'+pair_ID+' td:nth-child(2)').html(pairData['row']['clock']);
			
																
													$('#mainSummaryDiv_'+pair_ID+' #arrowBoxSpan').removeClass('upArrow downArrow noneArrow').addClass(pairData['arrowBoxClass']);
													$('#mainSummaryDiv_'+pair_ID+' #summaryLast').html(pairData['summaryLast']);
													$('#mainSummaryDiv_'+pair_ID+' #summaryName').html(pairData['summaryName']);
													$('#mainSummaryDiv_'+pair_ID+' #summaryChange').html(pairData['summaryChange']).removeClass('greenFont redFont').addClass(pairData['summaryChangeClass']);
													//$('#mainSummaryDiv_'+pair_ID+' #arrowBox').html(pairData['arrowBox']);
													//$('#mainSummaryDiv_'+pair_ID+' #dataBoxSummary').html(pairData['dataBoxSummary']);
													$('#mainSummaryDiv_'+pair_ID+' #technicalSummary').html(pairData['technicalSummary']).removeClass('buy sell neutral').addClass(pairData['technicalSummaryClass']);
													
													$('#mainSummaryDiv_'+pair_ID+' #maBuy').html('('+pairData['maBuy']+')');
													$('#mainSummaryDiv_'+pair_ID+' #maSell').html('('+pairData['maSell']+')');
													$('#mainSummaryDiv_'+pair_ID+' #tiBuy').html('('+pairData['tiBuy']+')');
													$('#mainSummaryDiv_'+pair_ID+' #tiSell').html('('+pairData['tiSell']+')');

													if (investingTechSummaryBox.hoveredPair_ID == pair_ID){
														$('#mainSummaryDiv #arrowBoxSpan').removeClass('upArrow downArrow noneArrow').addClass(pairData['arrowBoxClass']);
														$('#mainSummaryDiv #summaryLast').html(pairData['summaryLast']);
														$('#mainSummaryDiv #summaryName').html(pairData['summaryName']);
														$('#mainSummaryDiv #summaryName').attr('title', pairData['summaryNameAlt']);
														$('#mainSummaryDiv #summaryChange').html(pairData['summaryChange']).removeClass('greenFont redFont').addClass(pairData['summaryChangeClass']);
														//$('#mainSummaryDiv #arrowBox').html(pairData['arrowBox']);
														//$('#mainSummaryDiv #dataBoxSummary').html(pairData['dataBoxSummary']);
														$('#mainSummaryDiv #technicalSummary').html(pairData['technicalSummary']).removeClass('buy sell neutral').addClass(pairData['technicalSummaryClass']);
														
														$('#mainSummaryDiv #maBuy').html('('+pairData['maBuy']+')');
														$('#mainSummaryDiv #maSell').html('('+pairData['maSell']+')');
														$('#mainSummaryDiv #tiBuy').html('('+pairData['tiBuy']+')');
														$('#mainSummaryDiv #tiSell').html('('+pairData['tiSell']+')');
													}
												}	
											}
										}//if
										if (recursive)
											setTimeout( function() {
												investingTechSummaryBox.refresher(recursive);
											}, ajax_delay);
									},
								error:
									function(XMLHttpRequest, textStatus, errorThrown)
									{
										if(recursive)
											setTimeout( function() {
												investingTechSummaryBox.refresher(recursive);
											}, 35000);
									}
							});
			},
		 doNow 			: function(){
							 $('table[table="pairTable"] tr').each(function() {
							 	var id = this.id;						 		
							 	var handler = function() {
							 			$('#mainSummaryDiv').html( $('#mainSummaryDiv_'+id).html());
							 			investingTechSummaryBox.hoveredPair_ID = id;
							 			$("table[table=pairTable] tr").removeClass('selected');
							 			$('#'+id).addClass('selected');
							 	};
							 	$('#'+id).bind('mouseenter', handler);
							 });	
							 setTimeout(function() { investingTechSummaryBox.refresher(true); }, 20000);
							 var selectedTabId = $('#quotesBoxWithTabsTop li.selected').attr('id');
							 var pair_ID = $('#' + selectedTabId + '_inner').attr('pair_ID');
							 $('#'+pair_ID).addClass('selected');
						}()
	};