$(function() {
	getLocation();
	getCountryList();

	/*----------- init functions and variables ------------*/


	$(".about_inner,.acc_inner,.p_inner,.rc_inner,.pc_inner,.part_inner").slideUp();

	$('[data-toggle="tooltip"]').tooltip();
	$(".closebtn").click(function() {
		closeNav();
	});
	$("#nav_toggle").click(function() {
		openNav();
	});

	$(".about_us").click(function() {
		$(".about_inner").slideToggle();
	});
	$(".account_mob").click(function() {
		$(".acc_inner").slideToggle();
	});
	$(".platform_").click(function() {
		$(".p_inner").slideToggle();
	});
	$(".client_rc").click(function() {
		$(".rc_inner").slideToggle();
	});
	$(".pc").click(function() {
		$(".pc_inner").slideToggle();
	});
	$(".partner_").click(function() {
		$(".part_inner").slideToggle();
	});


	/* ---------------- mega menu ----------------------*/

	//add active class on menu
	// 	$('ul li').click(function(e) {
	// 		e.preventDefault();
	// 		$('li').removeClass('active');
	// 		$(this).addClass('active');
	// 	});

	//drop down menu	
	$(".about").click(function() {
		$('.abt').addClass('display-on');
	});
	$(".account").click(function() {
		$('.acc').addClass('display-on');
	});
	$(".platform").click(function() {
		$('.pltfm').addClass('display-on');
	});
	$(".cr").click(function() {
		$('.crr').addClass('display-on');
	});
	$(".promotion").click(function() {
		$('.pro').addClass('display-on');
	});
	$(".partner").click(function() {
		$('.pat').addClass('display-on');
	});
	$(".drop-down").mouseleave(function() {
		$('.mega-menu').removeClass('display-on');
	});


	/*-------------------- world map -------------------------------*/
	// world map integration end
	var map = AmCharts.makeChart("worldmap", {
		"type": "map",
		"theme": "light",
		"projection": "miller",

		"imagesSettings": {
			"rollOverColor": "#089282",
			"rollOverScale": 3,
			"selectedScale": 3,
			"selectedColor": "#089282",
			"color": "#13564e"
		},

		"areasSettings": {
			"unlistedAreasColor": "#ed2028"
		},

		"dataProvider": {
			"map": "worldLow",
			"images": [{
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Malaysia",
				"latitude": 4.2105,
				"longitude": 101.9758
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "India-Bangalore",
				"latitude": 13.9716,
				"longitude": 76.5946
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Hong kong",
				"latitude": 22.3964,
				"longitude": 111.1095
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "UK",
				"latitude": 55.0000,
				"longitude": -2.1000
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Dubai",
				"latitude": 25.2048,
				"longitude": 55.2708
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Chennai",
				"latitude": 13.0827,
				"longitude": 77.5946
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Kuwait",
				"latitude": 29.3117,
				"longitude": 47.4818
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Canada",
				"latitude": 56.1304,
				"longitude": -106.3468
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Indonesia",
				"latitude": 0.7893,
				"longitude": 113.9213
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "Chandigarh",
				"latitude": 30.7333,
				"longitude": 76.7794
			}, {
				"zoomLevel": 5,
				"scale": 0.5,
				"title": "South Africa",
				"latitude": -30.5595,
				"longitude": 22.9375
			}]
		}
	});

	// add events to recalculate map position when the map is moved or zoomed
	map.addListener("positionChanged", updateCustomMarkers);

	// this function will take current images on the map and create HTML elements for them
	function updateCustomMarkers(event) {
		// get map object
		var map = event.chart;

		// go through all of the images
		for (var x in map.dataProvider.images) {
			// get MapImage object
			var image = map.dataProvider.images[x];

			// check if it has corresponding HTML element
			if ('undefined' == typeof image.externalElement)
				image.externalElement = createCustomMarker(image);

			// reposition the element accoridng to coordinates
			var xy = map.coordinatesToStageXY(image.longitude, image.latitude);
			image.externalElement.style.top = xy.y + 'px';
			image.externalElement.style.left = xy.x + 'px';
		}
	}

	// this function creates and returns a new marker element
	function createCustomMarker(image) {
		// create holder
		var holder = document.createElement('div');
		holder.className = 'map-marker';
		holder.title = image.title;
		holder.style.position = 'absolute';

		// maybe add a link to it?
		if (undefined !== image.url) {
			holder.onclick = function() {
				window.location.href = image.url;
			};
			holder.className += ' map-clickable';
		}

		// create dot
		var dot = document.createElement('div');
		dot.className = 'dot';
		holder.appendChild(dot);

		// create pulse
		var pulse = document.createElement('div');
		pulse.className = 'pulse';
		holder.appendChild(pulse);

		// append the marker to the map container
		image.chart.chartDiv.appendChild(holder);
		return holder;
	}
	// world map integration end	


	$(document).on("mouseover", ".map-marker", function() {
		$(".country_ttl").html($(this).attr("title"));
		$(".popup_slide").addClass("popup_slide_");
	});
	$(document).on("mouseleave", ".map-marker", function() {
		$(".popup_slide").removeClass("popup_slide_");
	});

});

$("#ppCal").click(function(e) {
	e.preventDefault();
	var H = parseFloat($("#pp_hp").val());
	var L = parseFloat($("#pp_lp").val());
	var O = parseFloat($("#pp_op").val());
	var C = parseFloat($("#pp_cp").val());
	if (H > 0 && L > 0 && O > 0 && C > 0) {
		var P = (H + L + C) / 3;
		$("#pp_hp").removeClass('errorBdr');
		$("#pp_lp").removeClass('errorBdr');
		$("#pp_op").removeClass('errorBdr');
		$("#pp_cp").removeClass('errorBdr');
		$("#pp .f").html((P).toFixed(4));
		$("#r1 .f").html(((2 * P) - L).toFixed(4));
		$("#r2 .f").html((P + H - L).toFixed(4));
		$("#r3 .f").html((H + 2 * (P - L)).toFixed(4));
		$("#s1 .f").html(((2 * P) - H).toFixed(4));
		$("#s2 .f").html((P - H + L).toFixed(4));
		$("#s3 .f").html((L - 2 * (H - P)).toFixed(4));

		$("#pp .w").html(((H + L + 2 * C) / 4).toFixed(4));
		$("#r1 .w").html(((2 * P) - L).toFixed(4));
		$("#r2 .w").html((P + H - L).toFixed(4));
		$("#s1 .w").html(((2 * P) - H).toFixed(4));
		$("#s2 .w").html((P - H + L).toFixed(4));

		$("#r1 .c").html(((H - L) * 1.1 / 12 + C).toFixed(4));
		$("#r2 .c").html(((H - L) * 1.1 / 6 + C).toFixed(4));
		$("#r3 .c").html(((H - L) * 1.1 / 4 + C).toFixed(4));
		$("#r4 .c").html(((H - L) * 1.1 / 2 + C).toFixed(4));
		$("#s1 .c").html((C - (H - L) * 1.1 / 12).toFixed(4));
		$("#s2 .c").html((C - (H - L) * 1.1 / 6).toFixed(4));
		$("#s3 .c").html((C - (H - L) * 1.1 / 4).toFixed(4));
		$("#s4 .c").html((C - (H - L) * 1.1 / 2).toFixed(4));

		var x = 0;
		if (C < O) {
			x = H + 2 * L + C;
		} else if (C > O) {
			x = 2 * H + L + C;
		} else if (C == O) {
			x = H + L + 2 * C;
		}
		$("#r1 .d").html((x / 2 - L).toFixed(4));
		$("#s1 .d").html((x / 2 - H).toFixed(4));

		var PP = P;
		$("#pp .fi").html((PP).toFixed(4));
		$("#r1 .fi").html((PP + ((H - L) * 0.382)).toFixed(4));
		$("#r2 .fi").html((PP + ((H - L) * 0.618)).toFixed(4));
		$("#r3 .fi").html((PP + ((H - L) * 1.000)).toFixed(4));
		$("#s1 .fi").html((PP - ((H - L) * 0.382)).toFixed(4));
		$("#s2 .fi").html((PP - ((H - L) * 0.618)).toFixed(4));
		$("#s3 .fi").html((PP - ((H - L) * 1.000)).toFixed(4));
	} else {
		$("#pp_hp").addClass('errorBdr');
		$("#pp_lp").addClass('errorBdr');
		$("#pp_op").addClass('errorBdr');
		$("#pp_cp").addClass('errorBdr');
	}
});

$("#fCal").click(function(e) {
	e.preventDefault();
	var h = parseFloat($("#f_hp").val());
	var l = parseFloat($("#f_lp").val());

	if (h && l) {
		$("#f_hp").removeClass("errorBrd");
		$("#f_lp").removeClass("errorBrd");
		var fix = 4;
		if (($("#f_hp").val().substring(1, 2) != ".") && ($("#f_lp").val().substring(1, 2) != ",")) {
			fix = 2;
		} else {
			fix = 4;
		}
		var dif = (1 * h - 1 * l);
		$(".r100").html((h * 1).toFixed(fix));
		$(".r61").html((1 * l + dif * 61.8 / 100).toFixed(fix));
		$(".r50").html((1 * l + dif * 50 / 100).toFixed(fix));
		$(".r38").html((1 * l + dif * 38.2 / 100).toFixed(fix));
		$(".r23").html((1 * l + dif * 23.6 / 100).toFixed(fix));
		$(".r0").html((1 * l).toFixed(fix));


		$(".d100").html((l * 1).toFixed(fix));
		$(".d61").html((1 * h - dif * 61.8 / 100).toFixed(fix));
		$(".d50").html((1 * h - dif * 50 / 100).toFixed(fix));
		$(".d38").html((1 * h - dif * 38.2 / 100).toFixed(fix));
		$(".d23").html((1 * h - dif * 23.6 / 100).toFixed(fix));
		$(".d0").html((1 * h).toFixed(fix));
	} else {
		$("#f_hp").addClass("errorBrd");
		$("#f_lp").addClass("errorBrd");
	}

});

$("#calRisk").click(function(e) {
	e.preventDefault();
	var accountBase = $("#accountBase").val();
	var currencyPair = $("#currencyPair").val();
	var openPrice = $("#openPrice").val();
	var bs = "";
	var stopLoss = $("#stopLoss").val();
	var accBal = $("#accBal").val();
	var riskPer = $("#riskPer").val();
	var pair_right = currencyPair.substring(4, 7);

	if ($("#buy").is(":checked")) {
		bs = "BUY";
	} else {
		bs = "SELL";
	}

	if (openPrice && openPrice > 0 && stopLoss && stopLoss > 0 && accBal && accBal > 0 && riskPer && riskPer > 0) {
		var pips = 0;
		var rawpips = 0;
		if (bs === "BUY") {
			rawpips = openPrice - stopLoss;
		} else {
			rawpips = stopLoss - openPrice;
		}

		if (pair_right != "JPY") {
			pips = rawpips * 10000;
		} else {
			pips = rawpips * 100;
		}
		pips = pips.toFixed(2);
		stopLoss = pips;
		var pair = currencyPair.replace('/', '');
		var qry = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20yahoo.finance.xchange%20where%20pair%20in%20(%22" + pair + "%22)&env=store://datatables.org/alltableswithkeys";
		$.get(qry, function(result) {
			var xmlDoc = $.parseXML(result.results[0]);
			var $xml = $(xmlDoc);
			var pair_bid = $xml.find("rate[id]>Ask").text();
			var factor = 0;
			if (accountBase == "USD") {
				factor = 1;
			} else if (accountBase == "EUR") {
				factor = pair_bid["EURUSD"];
			} else if (accountBase == "ZAR") {
				factor = 1 / pair_bid["USDZAR"];
			}
			var factor2 = 1;
			var margin_pairs = ["EURUSD", "GBPUSD", "USDJPY", "USDCHF", "USDCAD", "AUDUSD", "NZDUSD"];

			if (pair_right != "USD" && pair_right != "EUR") {
				for (var i = 0; i < margin_pairs.length; i++) {
					if (margin_pairs[i].indexOf(pair_right) != -1) {
						if (margin_pairs[i].substring(0, 3) == pair_right) {
							factor2 = 1 / pair_bid[margin_pairs[i]];
						} else {
							factor2 = pair_bid[margin_pairs[i]];
						}
					}
				}
			}

			var ls;
			if (pair_right != "JPY") {
				ls = (riskPer / 100 * accBal * factor * factor2 / pips) / (0.0001 * 100000);
			} else {
				ls = (riskPer / 100 * accBal * factor * factor2 / pips) / (0.01 * 100000);
			}
			$(".sl").html(stopLoss);
			$(".lotSize").html(ls.toFixed(2));
		}, 'jsonp');
	} else {
		alert("Enter a valid input");
	}
});

/* ---------------- functions -----------------------*/

function openNav() {
	$("#mobile_menu").css("width", "360px");
}

function closeNav() {
	$("#mobile_menu").css("width", "0px");
}

/*----------------- contact form -------------*/

$("#contactForm").submit(function(event) {
	event.preventDefault();
	var access = false;
	var phoneNumber = $("#f_phone").val();
	if (Number.isInteger(parseInt(phoneNumber)) && phoneNumber > 50000 && phoneNumber.length > 9) {
		if (!$("#contactAlert").hasClass('hide')) {
			$("#contactAlert").addClass("hide");
		}
		access = true;
	} else {
		if ($("#contactAlert").hasClass('hide')) {
			$("#contactAlert").removeClass("hide").addClass("alert-danger");
		}
		$("#contactError").html('Error : Invalid Phone / Mobile number');
	}

	if (access) {
		var type = $("#f_type").children(":selected").val();
		var country = $("#contactCountryList").children(":selected").val();
		var sendData = {
			"name": $("#f_name").val(),
			"email": $("#f_email").val(),
			"country": country,
			"phoneNumber": $("#countryDialCode").val() + " - " + phoneNumber,
			"RequestType": type,
			"message": $("#f_message").val(),
			"type": "sendMailForContactForm"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#f_name").val('');
					$("#f_email").val('');
					$("#f_message").val('');
					$("#f_phone_c").val('');
					if ($("#contactAlert").hasClass('hide')) {
						$("#contactAlert").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#contactError").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#contactAlert").hasClass('hide')) {
						$("#contactAlert").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#contactAlert").hasClass('hide')) {
						$("#contactAlert").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#contactAlert").hasClass('hide')) {
						$("#contactAlert").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert").hasClass('hide')) {
						$("#contactAlert").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});
$("#contactFormRequest").submit(function(event) {
	event.preventDefault();

	if (true) {
		var type = $("#f_type_c").children(":selected").val();
		var sendData = {
			"name": $("#f_name_c").val(),
			"email": $("#f_email_c").val(),
			"accountId": $("#f_account_c_acc").val(),
			"RequestType": type,
			"message": $("#f_message_c").val(),
			"type": "sendMailForHeaderContactForm"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#f_name_c").val('');
					$("#f_email_c").val('');
					$("#f_account_c_acc").val('');
					$("#f_message_c").val('');
					if ($("#contactAlert_c").hasClass('hide')) {
						$("#contactAlert_c").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#contactError_c").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#contactAlert_c").hasClass('hide')) {
						$("#contactAlert_c").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_c").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#contactAlert_c").hasClass('hide')) {
						$("#contactAlert_c").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_c").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#contactAlert_c").hasClass('hide')) {
						$("#contactAlert_c").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_c").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert_c").hasClass('hide')) {
						$("#contactAlert_c").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_c").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});
$(document).on('click', '#emailHeader', function() {
	$("#contactAlert_c").addClass("hide");
	$("#f_name_c").val('');
	$("#f_email_c").val('');
	$("#f_phone_c").val('');
	$("#f_message_c").val('');
	$("#emailSendForm").modal('show');
});
$(document).on('click', '#numberHeader', function() {
	$("#contactAlert_cb").addClass("hide");
	$("#f_name_cb").val('');
	$("#f_email_cb").val('');
	$("#f_phone_cb").val('');
	$("#f_message_cb").val('');
	$("#callBackForm").modal('show');
});

function getCountryList() {
	var countryList = {};
	$("#contactCountryList, #contactRequest, #contactRequest_cb, #countriesPopup, .countryListK").html('');
	$.get("https://alphabetafx.com/wp-content/themes/maintheme-child/countryList.js", function(data) {
		countryList = data;
		$.each(countryList, function(index, ele) {
			$("#contactCountryList, #contactRequest, #contactRequest_cb, #countriesPopup, .countryListK").append("<option id=\"" + ele.dial_code + "\" value=\"" + ele.name + "\">" + ele.name + "</option>");
		});
	}, "json");
}

$("#contactCountryList").change(function() {
	$("#countryDialCode").val($(this).children(":selected").attr("id"));
});

$("#contactRequest").change(function() {
	$("#countryDialCode_c").val($(this).children(":selected").attr("id"));
});

$("#contactRequest_cb").change(function() {
	$("#countryDialCode_cb").val($(this).children(":selected").attr("id"));
});

$("#fm_country").change(function() {
	$("#fm_code").val($(this).children(":selected").attr("id"));
});

$("#rf_country").change(function() {
	$("#rf_code").val($(this).children(":selected").attr("id"));
});

$("#wl_country").change(function() {
	$("#wl_code").val($(this).children(":selected").attr("id"));
});

$("#gl_country").change(function() {
	$("#gl_code").val($(this).children(":selected").attr("id"));
});

$("#countriesPopup").change(function() {
	$("#countryDialCodeSignup").val($(this).children(":selected").attr("id"));
});

$("#chatHeader, .chatPopUP, .chatPopUp").click(function() {
	Tawk_API.popup();
});


$("#callBackRequest").submit(function(event) {
	event.preventDefault();
	var access = false;
	var phoneNumber = $("#f_phone_cb").val();
	if (Number.isInteger(parseInt(phoneNumber)) && phoneNumber > 50000 && phoneNumber.length > 9) {
		if (!$("#contactAlert_cb").hasClass('hide')) {
			$("#contactAlert_cb").addClass("hide");
		}
		access = true;
	} else {
		if ($("#contactAlert_cb").hasClass('hide')) {
			$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
		}
		$("#contactError_cb").html('Error : Invalid Phone / Mobile number');
	}

	if (access) {
		var date = $("#f_date_cb").val();
		var country = $("#contactRequest_cb").children(":selected").val();
		var sendData = {
			"name": $("#f_name_cb").val(),
			"email": $("#f_email_cb").val(),
			"country": country,
			"phoneNumber": $("#countryDialCode_cb").val() + " - " + phoneNumber,
			"date": date,
			"message": $("#f_message_cb").val(),
			"type": "callBackRequestForm"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#f_name_cb").val('');
					$("#f_email_cb").val('');
					$("#f_phone_cb").val('');
					$("#f_message_cb").val('');
					$("#f_date_cb").val('');
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#contactError_cb").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_cb").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_cb").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_cb").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#contactError_cb").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});

$("#fundmanagerForm").submit(function(event) {
	event.preventDefault();
	var access = false;
	var phoneNumber = $("#fm_phone").val();
	if (Number.isInteger(parseInt(phoneNumber)) && phoneNumber > 50000 && phoneNumber.length > 9) {
		if (!$("#Alert_fm").hasClass('hide')) {
			$("#Alert_fm").addClass("hide");
		}
		access = true;
	} else {
		if ($("#Alert_fm").hasClass('hide')) {
			$("#Alert_fm").removeClass("hide").addClass("alert-danger");
		}
		$("#Error_fm").html('Error : Invalid Phone / Mobile number');
	}

	if (access) {
		var date = $("#fm_dob").val();
		var country = $("#fm_country").children(":selected").val();
		var sendData = {
			"name": $("#fm_name").val(),
			"email": $("#fm_email").val(),
			"country": country,
			"phoneNumber": $("#fm_code").val() + " - " + phoneNumber,
			"date": date,
			"desc": $("#fm_desc").val(),
			"noClients": $("#fm_noClients").val(),
			"volume": $("#fm_volume").val(),
			"companyName": $("#fm_company").val(),
			"currency": $("#fm_currency").val(),
			"equity": $("#fm_equity").val(),
			"type": "fundmanagerForm"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#fm_name").val('');
					$("#fm_email").val('');
					$("#fm_phone").val('');
					$("#fm_desc").val('');
					$("#fm_dob").val('');
					$("#fm_code").val('');
					$("#fm_noClients").val('');
					$("#fm_company").val('');
					$("#fm_currency").val('');
					$("#fm_equity").val('');
					if ($("#Alert_fm").hasClass('hide')) {
						$("#Alert_fm").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#Error_fm").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#Alert_fm").hasClass('hide')) {
						$("#Alert_fm").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_fm").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#Alert_fm").hasClass('hide')) {
						$("#Alert_fm").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_fm").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#Alert_fm").hasClass('hide')) {
						$("#Alert_fm").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_fm").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_fm").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});

$("#regionalFranchise").submit(function(event) {
	event.preventDefault();
	var access = false;
	var phoneNumber = $("#rf_phone").val();
	if (Number.isInteger(parseInt(phoneNumber)) && phoneNumber > 50000 && phoneNumber.length > 9) {
		if (!$("#Alert_rf").hasClass('hide')) {
			$("#Alert_rf").addClass("hide");
		}
		access = true;
	} else {
		if ($("#Alert_rf").hasClass('hide')) {
			$("#Alert_rf").removeClass("hide").addClass("alert-danger");
		}
		$("#Error_rf").html('Error : Invalid Phone / Mobile number');
	}

	if (access) {
		var date = $("#rf_dob").val();
		var country = $("#rf_country").children(":selected").val();
		var sendData = {
			"name": $("#rf_name").val(),
			"email": $("#rf_email").val(),
			"country": country,
			"phoneNumber": $("#rf_code").val() + " - " + phoneNumber,
			"date": date,
			"desc": $("#rf_desc").val(),
			"noClients": $("#rf_noClients").val(),
			"volume": $("#rf_volume").val(),
			"companyName": $("#rf_company").val(),
			"currency": $("#rf_currency").val(),
			"equity": $("#rf_equity").val(),
			"type": "regionalFranchise"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#rf_name").val('');
					$("#rf_email").val('');
					$("#rf_phone").val('');
					$("#rf_desc").val('');
					$("#rf_dob").val('');
					$("#rf_code").val('');
					$("#rf_noClients").val('');
					$("#rf_company").val('');
					$("#rf_currency").val('');
					$("#rf_equity").val('');
					if ($("#Alert_rf").hasClass('hide')) {
						$("#Alert_rf").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#Error_rf").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#Alert_rf").hasClass('hide')) {
						$("#Alert_rf").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_rf").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#Alert_rf").hasClass('hide')) {
						$("#Alert_rf").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_rf").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#Alert_rf").hasClass('hide')) {
						$("#Alert_rf").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_rf").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_rf").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});

$("#whiteLabel").submit(function(event) {
	event.preventDefault();
	var access = false;
	var phoneNumber = $("#wl_phone").val();
	if (Number.isInteger(parseInt(phoneNumber)) && phoneNumber > 50000 && phoneNumber.length > 9) {
		if (!$("#Alert_wl").hasClass('hide')) {
			$("#Alert_wl").addClass("hide");
		}
		access = true;
	} else {
		if ($("#Alert_wl").hasClass('hide')) {
			$("#Alert_wl").removeClass("hide").addClass("alert-danger");
		}
		$("#Error_wl").html('Error : Invalid Phone / Mobile number');
	}

	if (access) {
		var date = $("#wl_dob").val();
		var country = $("#wl_country").children(":selected").val();
		var sendData = {
			"name": $("#wl_name").val(),
			"email": $("#wl_email").val(),
			"country": country,
			"phoneNumber": $("#wl_code").val() + " - " + phoneNumber,
			"date": date,
			"desc": $("#wl_desc").val(),
			"noClients": $("#wl_noClients").val(),
			"volume": $("#wl_volume").val(),
			"companyName": $("#wl_company").val(),
			"currency": $("#wl_currency").val(),
			"equity": $("#wl_equity").val(),
			"labelType": "white",
			"type": "label"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#wl_name").val('');
					$("#wl_email").val('');
					$("#wl_phone").val('');
					$("#wl_desc").val('');
					$("#wl_dob").val('');
					$("#wl_code").val('');
					$("#wl_noClients").val('');
					$("#wl_company").val('');
					$("#wl_currency").val('');
					$("#wl_equity").val('');
					if ($("#Alert_wl").hasClass('hide')) {
						$("#Alert_wl").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#Error_wl").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#Alert_wl").hasClass('hide')) {
						$("#Alert_wl").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_wl").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#Alert_wl").hasClass('hide')) {
						$("#Alert_wl").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_wl").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#Alert_wl").hasClass('hide')) {
						$("#Alert_wl").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_wl").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_wl").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});

$("#greyLabel").submit(function(event) {
	event.preventDefault();
	var access = false;
	var phoneNumber = $("#gl_phone").val();
	if (Number.isInteger(parseInt(phoneNumber)) && phoneNumber > 50000 && phoneNumber.length > 9) {
		if (!$("#Alert_gl").hasClass('hide')) {
			$("#Alert_gl").addClass("hide");
		}
		access = true;
	} else {
		if ($("#Alert_gl").hasClass('hide')) {
			$("#Alert_gl").removeClass("hide").addClass("alert-danger");
		}
		$("#Error_gl").html('Error : Invalid Phone / Mobile number');
	}

	if (access) {
		var date = $("#gl_dob").val();
		var country = $("#gl_country").children(":selected").val();
		var sendData = {
			"name": $("#gl_name").val(),
			"email": $("#gl_email").val(),
			"country": country,
			"phoneNumber": $("#gl_code").val() + " - " + phoneNumber,
			"date": date,
			"desc": $("#gl_desc").val(),
			"noClients": $("#gl_noClients").val(),
			"volume": $("#gl_volume").val(),
			"companyName": $("#gl_company").val(),
			"currency": $("#gl_currency").val(),
			"equity": $("#gl_equity").val(),
			"labelType": "grey",
			"type": "label"
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/customFunctions.php", sendData, function(data) {
			switch (data) {
				case "success":
					$("#gl_name").val('');
					$("#gl_email").val('');
					$("#gl_phone").val('');
					$("#gl_desc").val('');
					$("#gl_dob").val('');
					$("#gl_code").val('');
					$("#gl_noClients").val('');
					$("#gl_company").val('');
					$("#gl_currency").val('');
					$("#gl_equity").val('');
					if ($("#Alert_gl").hasClass('hide')) {
						$("#Alert_gl").addClass("alert-success").removeClass("hide alert-danger");
					}
					$("#Error_gl").html('Your Request has been received, Our Executive will contact you soon');
					break;
				case "error":
					if ($("#Alert_gl").hasClass('hide')) {
						$("#Alert_gl").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_gl").html('Error : Unable to Submit Form, Try again');
					break;
				case "invalidData":
					if ($("#Alert_gl").hasClass('hide')) {
						$("#Alert_gl").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_gl").html('Error : Unable to Submit Form, Check all the fields');
					break;
				case "Invalid Access":
					if ($("#Alert_gl").hasClass('hide')) {
						$("#Alert_gl").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_gl").html('Error : Unable to Submit Form, Check all the fields');
					break;
				default:
					if ($("#contactAlert_cb").hasClass('hide')) {
						$("#contactAlert_cb").removeClass("hide").addClass("alert-danger");
					}
					$("#Error_gl").html('Error : Unable to Submit Form, Check all the fields');
					break;
			}
		});
	}
});

$("#alpha_micro").change(function() {
	if ($(this).is(":checked")) {
		$(".comp-table>thead>tr>th:nth-child(2), .comp-table>tbody>tr>td:nth-child(2)").removeClass('hide');
	} else {
		$(".comp-table>thead>tr>th:nth-child(2), .comp-table>tbody>tr>td:nth-child(2)").addClass('hide');
	}
});

// $("#alpha_active").change(function() {
// 	if ($(this).is(":checked")) {
// 		$(".comp-table>thead>tr>th:nth-child(3), .comp-table>tbody>tr>td:nth-child(3)").removeClass('hide');
// 	} else {
// 		$(".comp-table>thead>tr>th:nth-child(3), .comp-table>tbody>tr>td:nth-child(3)").addClass('hide');
// 	}
// });

$("#alpha_standard").change(function() {
	if ($(this).is(":checked")) {
		$(".comp-table>thead>tr>th:nth-child(3), .comp-table>tbody>tr>td:nth-child(3)").removeClass('hide');
	} else {
		$(".comp-table>thead>tr>th:nth-child(3), .comp-table>tbody>tr>td:nth-child(3)").addClass('hide');
	}
});

$("#alpha_zero").change(function() {
	if ($(this).is(":checked")) {
		$(".comp-table>thead>tr>th:nth-child(4), .comp-table>tbody>tr>td:nth-child(4)").removeClass('hide');
	} else {
		$(".comp-table>thead>tr>th:nth-child(4), .comp-table>tbody>tr>td:nth-child(4)").addClass('hide');
	}
});

// $("#alpha_fixed").change(function() {
// 	if ($(this).is(":checked")) {
// 		$(".comp-table>thead>tr>th:nth-child(6), .comp-table>tbody>tr>td:nth-child(6)").removeClass('hide');
// 	} else {
// 		$(".comp-table>thead>tr>th:nth-child(6), .comp-table>tbody>tr>td:nth-child(6)").addClass('hide');
// 	}
// });

$("#alpha_ecn").change(function() {
	if ($(this).is(":checked")) {
		$(".comp-table>thead>tr>th:nth-child(5), .comp-table>tbody>tr>td:nth-child(5)").removeClass('hide');
	} else {
		$(".comp-table>thead>tr>th:nth-child(5), .comp-table>tbody>tr>td:nth-child(5)").addClass('hide');
	}
});

$("#alpha_pro").change(function() {
	if ($(this).is(":checked")) {
		$(".comp-table>thead>tr>th:nth-child(6), .comp-table>tbody>tr>td:nth-child(6)").removeClass('hide');
	} else {
		$(".comp-table>thead>tr>th:nth-child(6), .comp-table>tbody>tr>td:nth-child(6)").addClass('hide');
	}
});

$("#compareAccounts").change(function() {
	if ($(this).is(":checked")) {
		$("#selectCompBox").removeClass('hide');
	} else {
		$("#selectCompBox").addClass('hide');
		$(".comp-table>thead>tr>th:nth-child(2), .comp-table>tbody>tr>td:nth-child(2)").removeClass('hide');
// 		$(".comp-table>thead>tr>th:nth-child(3), .comp-table>tbody>tr>td:nth-child(3)").removeClass('hide');
		$(".comp-table>thead>tr>th:nth-child(3), .comp-table>tbody>tr>td:nth-child(3)").removeClass('hide');
		$(".comp-table>thead>tr>th:nth-child(4), .comp-table>tbody>tr>td:nth-child(4)").removeClass('hide');
		$(".comp-table>thead>tr>th:nth-child(5), .comp-table>tbody>tr>td:nth-child(5)").removeClass('hide');
		$(".comp-table>thead>tr>th:nth-child(6), .comp-table>tbody>tr>td:nth-child(6)").removeClass('hide');
// 		$(".comp-table>thead>tr>th:nth-child(8), .comp-table>tbody>tr>td:nth-child(8)").removeClass('hide');
	}
});


//change color of map pointer
$(function() {
	setTimeout(function() {
		$("[title='Canada'] > .dot").css("border-color", "yellow");
		$("[title='Canada'] > .pulse").css("background-color", "yellow");
		$("[title='Dubai'] > .dot").css("border-color", "yellow");
		$("[title='Dubai'] > .pulse").css("background-color", "yellow");
		$("[title='Chennai'] > .dot").css("border-color", "yellow");
		$("[title='Chennai'] > .pulse").css("background-color", "yellow");
		$("[title='Kuwait'] > .dot").css("border-color", "yellow");
		$("[title='Kuwait'] > .pulse").css("background-color", "yellow");
		$("[title='Indonesia'] > .dot").css("border-color", "yellow");
		$("[title='Indonesia'] > .pulse").css("background-color", "yellow");
		$("[title='Chandigarh'] > .dot").css("border-color", "yellow");
		$("[title='Chandigarh'] > .pulse").css("background-color", "yellow");
		$("[title='South Africa'] > .dot").css("border-color", "yellow");
		$("[title='South Africa'] > .pulse").css("background-color", "yellow");
	}, 5000);
});

$("#windowsLogo, .windowsLogo_").click(function() {
	$("#platformSelect").modal('show');
});

$("#apple_logo, .apple_logo_").click(function() {
	$("#platformSelectMac").modal('show');
});

$("#android_logo, .android_logo_").click(function() {
	$("#platformSelectAndroid").modal('show');
});

$("#web_logo, .web_logo_").click(function() {
	$("#platformSelectWeb").modal('show');
});

$("#ios_logo, .ios_logo").click(function() {
	$("#platformSelectIos").modal('show');
});

$(".registerSeminorForm").submit(function(e) {
	e.preventDefault();
	var name = $("#s_name").val();
	var mobile = $("#s_mobile").val();
	var email = $("#s_email").val();
	var from = $("#s_from").val();
	var comment = $("#s_comment").val();
	var seats = $("#seats").val();

	if (name === "" || name === undefined) {
		swal("", "Enter Full Name", "warning");
	} else if (mobile === "" || mobile === undefined) {
		swal("", "Enter Mobile Number", "warning");
	} else if (email === "" || email === undefined) {
		swal("", "Enter Email ID", "warning");
	} else if (from === "" || from === undefined) {
		swal("", "Select How did you hear about this event", "warning");
	} else if (seats <= 0 || seats === undefined) {
		swal("", "Select Number of Seats", "warning");
	} else {
		var param = {
			"reqType": "enrollSeminor",
			"name": name,
			"mobile": mobile,
			"email": email,
			"from": from,
			"comment": comment,
			"seats": seats
		};
		$.post("https://alphabetafx.com/wp-content/themes/maintheme-child/functions/seminorFunctions.php", param, function(response) {
			if (response === "duplicateEmail") {
				swal("", "You have already enrolled with the same email", "warning");
			} else if (response === "success") {
				$("#s_name").val('');
				$("#s_mobile").val('');
				$("#s_email").val('');
				$("#s_comment").val('');
				swal("", "You have successfully enrolled, We are awaiting to meet you on 5th May 2018", "success");
			} else {
				swal("", "Something went wrong, Try after sometime or contact our support", "warning");
			}
		});
	}
});

function getLocation() {
	var loc = "UNKNOWN";
	$.get("https://alphabetafx.com/wp-content/themes/maintheme-child/functions/getIP.php", function(response) {
		$.get("https://ipapi.co/" + response +"/json/", function(location) {
			loc = location.country_name;
			if (loc.toUpperCase() === ("India").toUpperCase()) {
				$(".HideOnCountry").removeClass('hide');
			} else {
				$(".HideOnCountry").addClass('hide');
			}
			if (loc.toUpperCase() === ("India").toUpperCase() || loc.toUpperCase() === ("Malaysia").toUpperCase()) {
				$("#whatsappIndia, #ssb-btn-0").removeClass('hide');
			} else {
				$("#whatsappIndia, #ssb-btn-0").addClass('hide');
			}
		});
	});
}

/*---------------   Seminar js functions ------------------*/

$("#seminar-chennai-view").click(function() {
	$("#seminar-chennai-body").toggleClass("hide");
	$("#seminar-chennai-view").toggleClass("fa-chevron-down");
});

$("#seminar-bangalore-view").click(function() {
	$("#seminar-bangalore-body").toggleClass("hide");
	$("#seminar-bangalore-view").toggleClass("fa-chevron-down");
});

$(document).ready(function() {
	(function($) {
		
  $("#owl-header").owlCarousel({
 
      navigation : false,
      slideSpeed : 300,
      paginationSpeed : 400,
      singleItem:true
		
  });	
		
		$('.owl-carousel').owlCarousel({
			loop: true,
			margin: 10,
			nav: false,
			responsive: {
				0: {
					items: 1
				},
				600: {
					items: 3
				},
				1000: {
					items: 5
				}
			}
		});
		
	})(jQuery);

	$('.counter').each(function() {
		var $this = $(this),
			countTo = $this.attr('data-count');
		$({
			countNum: $this.text()
		}).animate({
			countNum: countTo
		}, {
			duration: 8000,
			easing: 'linear',
			step: function() {
				$this.text(Math.floor(this.countNum));
			},
			complete: function() {
				$this.text(this.countNum);
			}
		});
	});
});

/*---------------   Seminar js dashboard function ------------------*/

 jQuery(document).ready(function($) {
 
        $('#myCarousel1').carousel1
        ({
                interval: 4000
        });
 
        //Handles the carousel thumbnails
        $('[id^=carousel-selector-]').click(function () {
        var id_selector = $(this).attr("id");
        try {
            var id = /-(\d+)$/.exec(id_selector)[1];
            console.log(id_selector, id);
            jQuery('#myCarousel1').carousel1(parseInt(id));
        } catch (e) {
            console.log('Regex failed!', e);
        }
    });
        // When the carousel slides, auto update the text
        $('#myCarousel1').on('slid.bs.carousel', function (e) {
                 var id = $('.item.active').data('slide-number');
                $('#carousel1-text').html($('#slide-content-'+id).html());
        });
});

/*---------------   Seminar for location wise image ------------------*/

    $( document ).ready(function() {

    $(function () {
        $('.mm_tooltip').tooltip({
            selector: "[data-toggle=tooltip]",
            container: "body"
        })
    });
 
    $('.thumbnail').hover(
        function(){
            $(this).find('.caption').slideDown(300); //.fadeIn(250)
        },
        function(){
            $(this).find('.caption').slideUp(200); //.fadeOut(205)
        }
    ); 
    
    $('#btndel').on('click', function(){
        alert('Are you sure you want to delete');
        
    });

});

/*----  payment gateway --> */

var activeEl = 3;
$(function() {
    var items = $('.btn-nav');
    $( items[activeEl] ).addClass('active');
    $( ".btn-nav" ).click(function() {
        $( items[activeEl] ).removeClass('active');
        $( this ).addClass('active');
        activeEl = $( ".btn-nav" ).index( this );
    });
});