dashboard.config(['$routeProvider', '$httpProvider', function($routeProvider, $httpProvider) {

  $routeProvider.when("/", {
      templateUrl: "../../dashboard/templateParts/indexBody"
    })

    .when("/dashboard", {
      templateUrl: "../../dashboard/templateParts/indexBody"
    })

    .when("/accounts", {
      templateUrl: "../../dashboard/templateParts/accounts"
    })

    .when("/subPartnerAccounts", {
      templateUrl: "../../dashboard/templateParts/subPartner"
    })

    .when("/profile", {
      templateUrl: "../../dashboard/templateParts/profile"
    })

    .when("/accountReport", {
      templateUrl: "../../dashboard/templateParts/accountsReport"
    })

    .when("/partnerReport", {
      templateUrl: "../../dashboard/templateParts/subPartnerReport"
    })

    .when("/verification", {
      templateUrl: "../../dashboard/templateParts/verification"
    })

    .when("/paymentRequest", {
      templateUrl: "../../dashboard/templateParts/paymentRequest"
    })

    .when("/smib", {
      templateUrl: "../../dashboard/templateParts/smib"
    })

    .when("/ib", {
      templateUrl: "../../dashboard/templateParts/ib"
    })

    .when("/clients", {
      templateUrl: "../../dashboard/templateParts/accounts"
    })

    .when("/changePassword", {
      templateUrl: "../../dashboard/templateParts/changePassword"
    })

    .when("/tradeAccounts/:userId", {
      templateUrl: "../../dashboard/templateParts/tradeAccounts"
    })

    .when("/tradeAccounts/:clientID/:clientName", {
      templateUrl: "../../dashboard/templateParts/viewTradeAccounts",
      controller: 'tradeAccounts'
    })

    .when("/ibRequest", {
      templateUrl: "../../dashboard/templateParts/IBRequest"
    })

    .when("/uploadBankDetail", {
      templateUrl: "../../dashboard/templateParts/uploadBankDetail"
    })

    .when("/smibChain/:smibID/:smibName", {
      templateUrl: "../../dashboard/templateParts/viewSMIBChain",
      controller: 'smibChain'
    })

    .when("/inviteClient", {
      templateUrl: "../../dashboard/templateParts/inviteClient"
    })

    .when("/tradeHistory", {
      templateUrl: "../../dashboard/templateParts/tradeHistory"
    })

    .when("/clientOnIB/:clientID", {
      templateUrl: "../../dashboard/templateParts/accountsOnIb",
      controller: 'ClientOnIB'
    })

    .otherwise({
      redirectTo: '/'
    });


  $httpProvider.interceptors.push(['$q', '$location', '$localStorage', '$cookies', '$document', function($q, $location, $localStorage, $cookies, $document) {
    return {
      'request': function(config) {
        config.headers = config.headers || {};
        if ($cookies.get('token')) {
          config.headers.Authorization = 'Bearer ' + $cookies.get('token');
        }
        return config;
      },
      'responseError': function(response) {
        if (response.status === 401 || response.status === 403) {
          $location.path('https://ib.alphabetafx.com');
        }
        return $q.reject(response);
      },
      'response': function(response) {
        return response;
      }
    };
  }]);
}]);

dashboard.constant('urls', {
  BASE: 'https://ib.alphabetafx.com',
  Login: '../../core/auth/auth'
});

dashboard.run(['jwtHelper', '$localStorage', '$window', '$location', '$http', '$cookies', function(jwtHelper, $localStorage, $window, $location, $http, $cookies) {
  var token = $cookies.get('token');

  //   check token status
  if ((token === null || token === undefined) && ($location.absUrl() !== '' && $location.absUrl() !== "https://ib.alphabetafx.com/" && $location.absUrl() !== "https://ib.alphabetafx.com/forgotPassword" && ($location.absUrl()).substr(0, 39) !== "https://ib.alphabetafx.com/ConfirmEmail" && ($location.absUrl()).substr(0, 40) !== "https://ib.alphabetafx.com/resetPassword" && ($location.absUrl()).substr(0, 33) !== "https://ib.alphabetafx.com/signup")) {
    $window.location = "https://ib.alphabetafx.com";
  }

  //  else if(($location.absUrl() !== "https://ib.alphabetafx.com/")){
  //     $http.post("../../core/auth/verify_token").then(function(response) {
  //       if (response.status === 200) {
  //         switch (response.data) {
  //           case "Invalid Token":
  //             $window.location = "https://ib.alphabetafx.com";
  //             break;
  //           case "Token expired":
  //             get_session_error();
  //             break;
  //         }
  //       }
  //     });
  //   }  

  //   check token state
  if ((token === null || token === undefined) && ($location.absUrl() !== '' && $location.absUrl() !== "https://ib.alphabetafx.com/" && $location.absUrl() !== "https://ib.alphabetafx.com/forgotPassword" && ($location.absUrl()).substr(0, 39) !== "https://ib.alphabetafx.com/ConfirmEmail" && ($location.absUrl()).substr(0, 40) !== "https://ib.alphabetafx.com/resetPassword" && ($location.absUrl()).substr(0, 33) !== "https://ib.alphabetafx.com/signup")) {
    get_session_error();
  }

  function get_session_error() {
    var exp = jwtHelper.isTokenExpired(token);
    if (exp) {
      swal({
          title: "Session Expired !",
          text: "Enter your password to Refresh access",
          type: "input",
          showCancelButton: false,
          closeOnConfirm: false,
          animation: "slide-from-top",
          inputPlaceholder: "Password"
        },
        function(inputValue) {
          if (inputValue === false) return false;

          if (inputValue === "") {
            swal.showInputError("You need to write something!");
            return false
          }
          $window.location = "https://ib.alphabetafx.com";
        });
    }
  }
}]);