/*-------------- user authorization -------------------*/
  dashboard.controller('authorization', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', 'Auth', '$cookies', function($scope, jwtHelper, $http, $location, $window, $localStorage, Auth, $cookies) {
    $scope.authorization_user = function(event) {
      event.preventDefault();
      var data = {
        "email": $scope.email,
        "password": $scope.password
      };

      function error(sts) {
        $scope.error = true;
        if (sts !== null || sts === 'pending' || sts === 'suspended' || sts === 'terminated') {
          $scope.sts = "Account status is " + sts + " !, Contact our support.";
        } else {
          $scope.sts = "Incorrect email or password.";
        }
      }

      function success(res) {
        var date = new Date();
        var minutes = 30;
        date.setTime(date.getTime() + (minutes * 60 * 1000));
        $cookies.put('token', res.token, {
          expires: date
        });
        $localStorage.client_details = JSON.parse(res.client_details);
        $window.location = "/dashboard";
        $scope.error = false;
      }

      Auth.signin(data, success, error);
    }
  }]);

  dashboard.controller('passwordReset', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', 'Auth', '$cookies', function($scope, jwtHelper, $http, $location, $window, $localStorage, Auth, $cookies) {

    $scope.resetPassword = function(e) {
      e.preventDefault();
      var data = {
        "requestType": "resetPassword",
        "email": $scope.resetEmail,
        "number": $scope.resetNumber
      };
      $http.post("../../core/functions/passwordReset", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.error_r = true;
          $scope.resetStatus = true;
          $scope.resetEmail = '';
          $scope.resetNumber = '';
          $scope.stsReset = "Reset link has been sent to your mail";
        } else {
          $scope.error_r = true;
          $scope.resetStatus = false;
          $scope.stsReset = "Recheck your email / Mobile number";
        }
      }, function() {
        $scope.error_r = true;
        $scope.resetStatus = false;
        $scope.stsReset = "Recheck your email / Mobile number";
      });
    }

  }]);

  dashboard.controller('resetNewPassword', ['$scope', '$timeout', '$http', '$location', '$window', '$localStorage', 'Auth', '$cookies', function($scope, $timeout, $http, $location, $window, $localStorage, Auth, $cookies) {
    var partnerId = $("#partnerId").val();
    var token = $("#token").val();

    $scope.checkPwd = function(pwd) {
      var pwdStrength = checkPasswordStrength(pwd);
      if (pwdStrength == "short" || pwdStrength == "weak") {
        $scope.bdrError = true;
      } else {
        $scope.bdrError = false;
      }
    }

    $scope.resetPassword = function(e) {
      e.preventDefault();
      if (!$scope.bdrError) {
        var data = {
          "requestType": "resetPassword",
          "token": token,
          "partnerId": partnerId,
          "newPassword": $scope.password
        };
        $http.post("../../core/functions/resetPassword", data).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            swal("", "Password has been resetted", "success");
            $timeout(function() {
              $window.location = "https://ib.alphabetafx.com";
            }, 2000);
          } else {
            swal("", "Error : unable to reset password, Contact your admin", "warning");
          }
        }, function() {
          swal("", "Error : unable to reset password, Contact your admin", "warning");
        });
      } else {
        $scope.bdrError = true;
      }
    }

    function checkPasswordStrength(password) {
      if (password === undefined) {
        password = "i";
      } else {
        password = password;
      }
      var strength = 0
      if (password.length < 6) {
        return 'short';
      }

      if (password.length > 7) strength += 1;
      if (password.match(/([a-z].*[A-Z])|([A-Z].*[a-z])/)) strength += 1;
      if (password.match(/([a-zA-Z])/) && password.match(/([0-9])/)) strength += 1;
      if (password.match(/([!,%,&,@,#,$,^,*,?,_,~])/)) strength += 1;
      if (password.match(/(.*[!,%,&,@,#,$,^,*,?,_,~].*[!,%,&,@,#,$,^,*,?,_,~])/)) strength += 1;

      if (strength < 2) {
        return 'weak';
      } else if (strength == 2) {
        return 'good';
      } else {
        return 'strong';
      }
    }
  }]);


  dashboard.controller('headerMenu', ['$scope', '$http', '$window', '$location', 'Auth', '$localStorage', '$cookies', function($scope, $http, $window, $location, Auth, $localStorage, $cookies) {
    $scope.token = Auth.getTokenClaims();
    $scope.client_details = $localStorage.client_details;

    function success() {
      $window.location = "https://ib.alphabetafx.com";
      $cookies.remove('token', {
        path: '/'
      });
    }
    $scope.logout = function() {
      Auth.logout(success);
    }
  }]);

  dashboard.controller('registerPartnerAccount', ['$scope', '$http', '$window', '$location', 'Auth', '$localStorage', '$cookies', '$timeout', function($scope, $http, $window, $location, Auth, $localStorage, $cookies, $timeout) {
    getCountryList();
    $scope.currencyBase = "USD";
    $scope.tc = true;

    $scope.registerPartner = function(e) {
      e.preventDefault();
      let partnerId = "noID";
      let type = "IB";

      let data = {
        "requestType": "addNewPartner",
        "currencyBase": $scope.currencyBase,
        "country": $scope.client_country.name,
        "code": $scope.client_country.dial_code,
        "partnerType": $scope.partnerType,
        "number": $scope.number,
        "name": $scope.name,
        "dob": $scope.dob,
        "email": $scope.email,
        "partnerAccountType": $scope.partnerAccountType,
        "ibExperience": $scope.ibExperience,
        "companyName": "noCompany",
        "website": "noWebsite",
        "noClients": $scope.noClients,
        "estDeposite": $scope.estDeposite,
        "clientSource": $scope.clientSource + "," + $scope.clientSourceOther || '',
        "partnerId": partnerId,
        "address": $scope.address,
        "type": type,
        "region": $scope.region,
        "state": $scope.state,
        "zipcode": $scope.zipcode,
        "city": $scope.city
      };
      $http.post("../../core/functions/registerPartner", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.client_country.name = '';
          $scope.client_country.dial_code = '';
          $scope.partnerType = '';
          $scope.number = '';
          $scope.name = '';
          $scope.dob = '';
          $scope.email = '';
          $scope.partnerAccountType = '';
          $scope.ibExperience = '';
          $scope.companyName = '';
          $scope.website = '';
          $scope.noClients = '';
          $scope.estDeposite = '';
          $scope.clientSource = '';
          $scope.clientSourceOther = '';
          $scope.refId = '';
          $scope.region = '';
          $scope.state = '';
          $scope.zipcode = '';
          $scope.city = '';
          swal("", "IB Request Sent, Check Your Mail for Login Details", "success");

          $timeout(function() {
            $window.location = "https://ib.alphabetafx.com";
          }, 3000);
        } else if (response.data.status === "duplicate") {
          swal("", "User already exist", "warning");
        } else {
          swal("", "Error : Unable to register IB", "error");
        }
      }, function() {
        swal("", "Error : Unable to register IB", "error");
      });
    }

    function getCountryList() {
      $http.get("https://ib.alphabetafx.com/assets/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }
  }]);

  dashboard.controller('emailMarketing', ['$scope', '$http', '$window', '$location', 'Auth', '$localStorage', '$filter', 'getOptionsList', 'getMarketingTools', 'ngCopy', function($scope, $http, $window, $location, Auth, $localStorage, $filter, getOptionsList, getMarketingTools, ngCopy) {
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.emailTemplates = [];
    $scope.bannerTypes = ["clients", "affiliates", "ib"];
    $scope.q = '';
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.emailTemplates, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    $scope.noData = false;

    getOptionsList.getCategory("email").then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.categorylist = response.data.list;
      } else {
        $scope.categorylist = [];
      }
    });

    getOptionsList.getLanguage().then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.languageList = response.data.list;
      } else {
        $scope.languageList = [];
      }
    });
    getMarketingTools.getEmailTemplates().then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.emailTemplates = response.data.list;
      } else if (response.data.status === "noData") {
        $scope.noData = true;
        $scope.emailTemplates = [];
      }
    }, function() {
      $scope.noData = true;
      $scope.emailTemplates = [];
    });

    $scope.copyCode = function(temp) {
      var url = '';
      if (temp.bannerFor === "clients") {
        url = "https://client.alphabetafx.com/Account/Register";
      } else if (temp.bannerFor === "affiliates") {
        url = "https://ib.alphabetafx.com/signup";
      }
      var partnerId = $localStorage.client_details.partnerId;
      var code = "<a href=\"" + url + "?P=" + partnerId + "&T=" + temp.uniqueId + "&type=email\" target=\"_blank\"><img src=\"https://abfxadmincrm.alphabetafx.com/assets/dir/emailTemplate/" + temp.name + "\" alt=\"banner\"></a>";
      ngCopy(code);
    }
  }]);

  dashboard.controller('bannerMarketingTool', ['$scope', '$http', '$window', '$location', 'Auth', '$localStorage', '$filter', 'getOptionsList', 'getMarketingTools', 'ngCopy', function($scope, $http, $window, $location, Auth, $localStorage, $filter, getOptionsList, getMarketingTools, ngCopy) {
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.bannerList = [];
    $scope.bannerTypes = ["clients", "affiliates", "ib"];
    $scope.q = '';
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.bannerList, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    $scope.noData = false;

    getOptionsList.getCategory("email").then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.categorylist = response.data.list;
      } else {
        $scope.categorylist = [];
      }
    });

    getOptionsList.getLanguage().then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.languageList = response.data.list;
      } else {
        $scope.languageList = [];
      }
    });

    getMarketingTools.getBanners().then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.bannerList = response.data.list;
      } else if (response.data.status === "noData") {
        $scope.noData = true;
        $scope.bannerList = [];
      }
    }, function() {
      $scope.noData = true;
      $scope.bannerList = [];
    });

    $scope.copyCode = function(temp) {
      var url = '';
      if (temp.bannerFor === "clients") {
        url = "https://client.alphabetafx.com/Account/Register";
      } else if (temp.bannerFor === "affiliates") {
        url = "https://ib.alphabetafx.com/signup";
      }
      var partnerId = $localStorage.client_details.partnerId;
      var code = "<a href=\"" + url + "?P=" + partnerId + "&T=" + temp.uniqueId + "&type=banner\" target=\"_blank\"><img src=\"https://abfxadmincrm.alphabetafx.com/assets/dir/bannerTemplate/" + temp.name + "\" alt=\"banner\"></a>";
      ngCopy(code);
    }
  }]);

  dashboard.controller('landingPageMarketingTool', ['$scope', '$http', '$window', '$location', 'Auth', '$localStorage', '$filter', 'getOptionsList', 'getMarketingTools', 'ngCopy', function($scope, $http, $window, $location, Auth, $localStorage, $filter, getOptionsList, getMarketingTools, ngCopy) {
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.landingPageList = [];
    $scope.q = '';
    $scope.bannerTypes = ["clients", "affiliates", "ib"];
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.landingPageList, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    $scope.noData = false;

    getOptionsList.getCategory("email").then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.categorylist = response.data.list;
      } else {
        $scope.categorylist = [];
      }
    });

    getOptionsList.getLanguage().then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.languageList = response.data.list;
      } else {
        $scope.languageList = [];
      }
    });

    getMarketingTools.getLandingPage().then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        $scope.noData = false;
        $scope.landingPageList = response.data.list;
      } else if (response.data.status === "noData") {
        $scope.noData = true;
        $scope.landingPageList = [];
      }
    }, function() {
      $scope.noData = true;
      $scope.landingPageList = [];
    });

    $scope.copyCode = function(temp) {
      var url = temp.url;
      //       if(temp.bannerFor === "clients"){
      //         url = "https://client.alphabetafx.com/Account/Register";
      //       } else if(temp.bannerFor === "affiliates"){
      //         url = "https://ib.alphabetafx.com/signup";
      //       }
      var partnerId = $localStorage.client_details.partnerId;
      var code = "<a href=\"" + url + "?P=" + partnerId + "&T=" + temp.uniqueId + "&type=landingPage\" target=\"_blank\"><img src=\"https://abfxadmincrm.alphabetafx.com/assets/dir/bannerTemplate/" + temp.name + "\" alt=\"banner\"></a>";
      ngCopy(code);
    }
  }]);

  dashboard.controller('profile_controller', ['$scope', '$http', '$window', '$location', '$localStorage', 'Upload', '$timeout', function($scope, $http, $window, $location, $localStorage, Upload, $timeout) {
    $scope.client_details = $localStorage.client_details;
    $scope.profile_pic = $localStorage.client_details.profile_pic;
    var v = $localStorage.client_details;
    var pic = '';
    $scope.upload = function(file) {
      Upload.upload({
        url: '../../core/functions/profile_pic_upload',
        data: {
          file: file
        }
      }).then(function(resp) {
        if (resp.status === 200) {
          var status = resp.data.status;
          switch (status) {
            case "no_file":
              break;
            case "invalid_file":
              swal("", "Select valid image type", "warning");
              break;
            case "file_exist":
              swal("", "Image already exist", "warning");
              break;
            case "success":
              pic = resp.data.pic_url;
              $timeout(function() {
                v.profile_pic = pic;
                $scope.profile_pic = pic;
              }, 1000);
              break;
            case "invalid_token":
              swal("", "Session Expired", "error");
              break;
            default:
              swal("", "Profile pic not updated", "warning");
          }
        } else {
          swal("", "Update failed", "error");
        }
      }, function(resp) {
        swal("", "Update failed", "error");
      }, function(evt) {
        var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
        //       console.log('progress: ' + progressPercentage + '% ' + evt.config.data.file.name);
      });
    };

    login_history();

    function login_history() {
      $http.post("../../core/functions/login_history").then(function(response) {
        if (response.status === 200) {
          if (response.data.status !== "no_data") {
            $scope.login_list = response.data;
            $scope.error = false;
          } else {
            $scope.login_empty = "0 Login records";
            $scope.error = true;
          }
        } else {
          $scope.login_empty = "0 Login records";
          $scope.error = true;
        }
      }, function() {
        $scope.login_empty = "0 Login records";
        $scope.error = true;
      });
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }
  }]);

  dashboard.controller('indexBody', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', 'Auth', '$cookies', '$filter', function($scope, jwtHelper, $http, $location, $window, $localStorage, Auth, $cookies, $filter) {
    getPaymentHistory();
    getUserDetails();
    getWalletDetails();

    var chartDate = [];
    var chartDataView = [];
    var chartDataReg = [];

    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED" || status === "APPROVED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED" || status === "CANCELLED" || status === "REJECTED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    getTotalClient();

    $scope.checkBank = function(bank, gateway) {
      if (gateway !== "Bank Transfer") {
        return bank;
      } else {
        bank = JSON.parse(bank);
        return bank.bankName + "  -  " + bank.accountNumber;
      }
    }

    function getTotalClient() {
      var data = {
        "requestType": "getClientTotal"
      };
      $http.post("../../core/functions/getIBSTotal", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.totalClient = response.data.total;
        } else {
          $scope.totalClient = 0;
        }
      }, function() {});
    }

    function getPaymentHistory() {
      var data = {
        "requestType": "paymentRequestHistory"
      };
      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    function getUserDetails() {
      var data = {
        "requestType": "getUserDetails"
      };
      $http.post("../../core/functions/getUserDetail", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.cdetails = response.data;
        } else if (response.data.status === "noData") {
          $scope.cdetails = [];
        } else {
          $scope.cdetails = [];
        }
      }, function() {
        $scope.cdetails = [];
      });
    }

    function getWalletDetails() {

      var data = {
        "requestType": "getWalletDetails"
      };
      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.walletDetails = response.data.info;
        }
      }, function() {});

    }

    $scope.cancelPaymentProcess = function(detail) {
      var data = {
        "requestType": "cancelPaymentProcess",
        "batchId": detail.batchId
      };

      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          getPaymentHistory();
          swal("", "Payment processing has been cancelled", "success");
        } else {
          if (detail.status !== 'pending') {
            swal("", "Cannot cancel payment process on the status of " + detail.status, "warning");
          } else {
            swal("", "unable to cancel payment, contact our support", "warning");
          }
        }
      }, function() {
        swal("", "unable to cancel payment, contact our support", "warning");
      });
    }

    $http.get("../../core/functions/getChartData").then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {

        var obj = Object.keys(response.data.info).length;
        if (obj > 0) {

          for (var i = obj - 1; i >= 0; i--) {
            chartDate.push(response.data.info[i].date);
            chartDataView.push(response.data.info[i].lots);
          }

          $scope.adImp = response.data.view;
          $scope.adReg = response.data.reg;
          updateChart();
        } else {
          chartDataView = [];
          chartDate = [];
          updateChart();
        }

      } else {
        chartDataView = [];
        chartDate = [];
        updateChart();
      }
    });

    function updateChart() {
      Highcharts.chart('trackAds', {

        xAxis: {
          categories: chartDate,
          allowDecimals: false,
          title: {
            text: 'Date'
          }
        },

        title: {
          text: "IB Lots",
          y: 20,
          margin: 25
        },

        credits: {
          enabled: false
        },

        series: [{
          name: "Lots",
          data: chartDataView
        }],

        yAxis: {
          title: {
            text: 'Commission in $'
          }
        }
      });
    }

  }]);

  dashboard.controller('partnerAccounts', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.partnerEmail = $localStorage.client_details.email;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    getCountryList();

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    function getCountryList() {
      $http.get("https://ib.alphabetafx.com/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients();

    function getClients() {
      $http.get("../../core/functions/getClientInfo").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.addClient = function() {
      $("#addNewClient").modal('show');
      $scope.client_name = '';
      $scope.client_number = '';
      $scope.client_address = '';
      $scope.client_email = '';
      $scope.client_country = '';
      $scope.client_username = '';
      $scope.userId = '';
      $scope.update = false;
    }

    $scope.editUser = function(detail) {
      $("#addNewClient").modal('show');
      $scope.client_name = detail.name;
      $scope.client_number = detail.number;
      $scope.client_address = detail.address;
      $scope.client_email = detail.email;
      $scope.client_country = undefined;
      $scope.client_username = detail.username;
      $scope.userId = detail.id;
      $scope.update = true;
    }

    $scope.updateClient = function() {
      processMode = 'update';
    }

    $scope.addClient_ = function() {
      processMode = 'new';
    }

    $scope.addNewClient = function(e) {
      e.preventDefault();
      if (processMode === 'update') {
        var data = {
          "requestType": "updateClient",
          "name": $scope.client_name,
          "email": $scope.client_email,
          "number": $scope.client_number,
          "address": $scope.client_address,
          "country": $scope.client_country.name,
          "code": $scope.client_country.dial_code || "+91",
          "userId": $scope.userId
        };
        $http.post("../../core/functions/addNewClients", data).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            $("#addNewClient").modal('hide');
            $scope.client_name = '';
            $scope.client_number = '';
            $scope.client_address = '';
            $scope.client_email = '';
            $scope.client_country = '';
            $scope.client_username = '';
            swal("", "client details updated", "success");
            getClients();
          } else if (response.data.status === "duplicate_user") {
            swal("", "Duplicate Information Update", "warning");
          } else {
            swal("", "unable to update client details", "error");
          }
        }, function() {
          swal("", "unable to update client details", "error");
        });
      } else if (processMode === 'new') {
        var data_ = {
          "requestType": "addNewClient",
          "name": $scope.client_name,
          "number": $scope.client_number,
          "address": $scope.client_address,
          "country": $scope.client_country.name,
          "code": $scope.client_country.dial_code || "+91",
          "email": $scope.client_email,
          "username": $scope.client_username,
          "partnerId": $scope.partnerId,
          "partnerEmail": $scope.partnerEmail
        };
        $http.post("../../core/functions/addNewClients", data_).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            $("#addNewClient").modal('hide');
            $scope.client_name = '';
            $scope.client_number = '';
            $scope.client_address = '';
            $scope.client_email = '';
            $scope.client_country = '';
            $scope.client_username = '';
            swal("", "client details updated", "success");
            getClients();
          } else if (response.data.status === "duplicate_user") {
            swal("", "Client Already Exist", "warning");
          } else {
            swal("", "unable to update client details", "error");
          }
        }, function() {
          swal("", "unable to update client details", "error");
        });
      }
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('smib', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.partnerEmail = $localStorage.client_details.email;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    getCountryList();

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    function getCountryList() {
      $http.get("https://ib.alphabetafx.com/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients();

    function getClients() {
      $http.get("../../core/functions/getSMIB").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.addClient = function() {
      $("#addNewClient").modal('show');
      $scope.client_name = '';
      $scope.client_number = '';
      $scope.client_address = '';
      $scope.client_email = '';
      $scope.client_country = '';
      $scope.client_username = '';
      $scope.userId = '';
      $scope.update = false;
    }

    $scope.editUser = function(detail) {
      $("#addNewClient").modal('show');
      $scope.client_name = detail.name;
      $scope.client_number = detail.number;
      $scope.client_address = detail.address;
      $scope.client_email = detail.email;
      $scope.client_country = undefined;
      $scope.client_username = detail.name;
      $scope.userId = detail.id;
      $scope.update = true;
    }

    $scope.updateClient = function() {
      processMode = 'update';
    }

    $scope.addClient_ = function() {
      processMode = 'new';
    }

    $scope.addNewClient = function(e) {
      e.preventDefault();
      if (processMode === 'update') {
        var data = {
          "requestType": "updateClient",
          "name": $scope.client_name,
          "email": $scope.client_email,
          "number": $scope.client_number,
          "address": $scope.client_address,
          "country": $scope.client_country.name,
          "code": $scope.client_country.dial_code || "+91",
          "userId": $scope.userId
        };
        $http.post("../../core/functions/addNewSMIB", data).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            $("#addNewClient").modal('hide');
            $scope.client_name = '';
            $scope.client_number = '';
            $scope.client_address = '';
            $scope.client_email = '';
            $scope.client_country = '';
            $scope.client_username = '';
            swal("", "client details updated", "success");
            getClients();
          } else if (response.data.status === "duplicate_user") {
            swal("", "Duplicate Information Update", "warning");
          } else {
            swal("", "unable to update client details", "error");
          }
        }, function() {
          swal("", "unable to update client details", "error");
        });
      } else if (processMode === 'new') {
        var data_ = {
          "requestType": "addNewClient",
          "name": $scope.client_name,
          "number": $scope.client_number,
          "address": $scope.client_address,
          "country": $scope.client_country.name,
          "code": $scope.client_country.dial_code || "+91",
          "email": $scope.client_email,
          "username": $scope.client_username,
          "partnerId": $scope.partnerId,
          "partnerEmail": $scope.partnerEmail
        };
        $http.post("../../core/functions/addNewSMIB", data_).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            $("#addNewClient").modal('hide');
            $scope.client_name = '';
            $scope.client_number = '';
            $scope.client_address = '';
            $scope.client_email = '';
            $scope.client_country = '';
            $scope.client_username = '';
            swal("", "client details updated", "success");
            getClients();
          } else if (response.data.status === "duplicate_user") {
            swal("", "Client Already Exist", "warning");
          } else {
            swal("", "unable to update client details", "error");
          }
        }, function() {
          swal("", "unable to update client details", "error");
        });
      }
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('ib', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.partnerEmail = $localStorage.client_details.email;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    getCountryList();

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    function getCountryList() {
      $http.get("https://ib.alphabetafx.com/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients();

    function getClients() {
      $http.get("../../core/functions/getIB").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.addClient = function() {
      $("#addNewIBT2").modal('show');
      $scope.client_name = '';
      $scope.client_number = '';
      $scope.client_address = '';
      $scope.client_email = '';
      $scope.client_country = '';
      $scope.client_username = '';
      $scope.userId = '';
      $scope.update = false;
    }

    $scope.addNewClient = function(e) {
      e.preventDefault();
      var data_ = {
        "requestType": "addNewClient",
        "name": $scope.client_name,
        "number": $scope.client_number,
        "address": $scope.client_address,
        "country": $scope.client_country.name,
        "code": $scope.client_country.dial_code || "+91",
        "email": $scope.client_email,
        "username": $scope.client_username,
        "partnerId": $scope.partnerId,
        "partnerEmail": $scope.partnerEmail,
        "dob": $scope.dob,
        "region": $scope.region,
        "state": $scope.state,
        "zipcode": $scope.zipcode,
        "city": $scope.city
      };
      $http.post("../../core/functions/addNewIB", data_).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $("#addNewIBT2").modal('hide');
          $scope.client_name = '';
          $scope.client_number = '';
          $scope.client_address = '';
          $scope.client_email = '';
          $scope.client_country = '';
          $scope.client_username = '';
          $scope.dob = '';
          $scope.region = '';
          $scope.state = '';
          $scope.zipcode = '';
          $scope.city = '';

          swal("", "IB Request Submitted", "success");
          getClients();
        } else if (response.data.status === "duplicate_user") {
          swal("", "Client Already Exist", "warning");
        } else {
          swal("", "Unable to request IB Account", "error");
        }
      }, function() {
        swal("", "Unable to request IB Account", "error");
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);


  dashboard.controller('subPartnerAccounts', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }

    getClients();

    function getClients() {
      $http.get("../../core/functions/getPartnerInfo").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('verificationCtrl', ['$scope', 'Upload', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, Upload, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    var pic = '';
    getVerficationInfo();
    $scope.upload = function(file, type) {
      Upload.upload({
        url: '../../core/functions/uploadDoc',
        data: {
          file: file,
          "fileType": type
        }
      }).then(function(resp) {
        if (resp.status === 200) {
          var status = resp.data.status;
          switch (status) {
            case "no_file":
              break;
            case "invalid_file":
              swal("", "Select valid image type", "warning");
              break;
            case "file_exist":
              swal("", "Image already exist", "warning");
              break;
            case "success":
              pic = resp.data.pic_url;
              $timeout(function() {
                if (type === 'id') {
                  $scope.idProof = pic;
                } else if (type === 'address') {
                  $scope.addressProof = pic;
                }
              }, 1000);
              break;
            case "invalid_token":
              swal("", "Session Expired", "error");
              break;
            default:
              swal("", "Profile pic not updated", "warning");
          }
        } else {
          swal("", "Update failed", "error");
        }
      }, function(resp) {
        swal("", "Update failed", "error");
      }, function(evt) {
        var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
        //       console.log('progress: ' + progressPercentage + '% ' + evt.config.data.file.name);
      });
    };

    function getVerficationInfo() {
      var data = {
        "requestType": "getVerficationInfo"
      };
      $http.post("../../core/functions/getVerficationInfo", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.verDetails = response.data.info;

          if (response.data.info.idDetail !== null) {
            var id = JSON.parse(response.data.info.idDetail);
            $scope.idProof = "../../assets/dir/documents/" + id.name;
            $scope._id = id;
          } else {
            $scope.idProof = undefined;
          }

          if (response.data.info.addressDetail !== null) {
            var address = JSON.parse(response.data.info.addressDetail);
            $scope.addressProof = "../../assets/dir/documents/" + address.name;
            $scope._address = address;
          } else {
            $scope.addressProof = undefined;
          }

        } else {
          $scope.verDetails = undefined;
        }
      }, function() {
        $scope.verDetails = undefined;
      });
    }

    $scope.removeDoc = function(doc, type) {
      var docId = doc.imgId;
      var docName = doc.name;
      var data = {
        "requestType": "removeDoc",
        "docType": type,
        "docId": docId,
        "docName": docName
      };
      $http.post("../../core/functions/getVerficationInfo", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          if (type === 'id') {
            $scope.idProof = undefined;
          } else if (type === 'address') {
            $scope.addressProof = undefined;
          }
          swal("", "verification document removed", "success");
        } else {
          swal("", "error on removing verification document", "warning");
        }
      }, function() {
        swal("", "error on removing verification document", "warning");
      });
    }

    $scope.resendEmailVerification = function() {
      var data = {
        "requestType": "resendEmailVerification"
      };
      $http.post("../../core/functions/verResend", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          swal("", "Email Resended", "success");
        } else {
          swal("", "error on sending mail", "warning");
        }
      }, function() {
        swal("", "error on sending mail", "warning");
      });
    }
  }]);

  dashboard.controller('campaignAnalytics', ['$scope', '$http', '$window', '$location', 'Auth', '$localStorage', '$filter', 'getMarketingTools', 'ngCopy', function($scope, $http, $window, $location, Auth, $localStorage, $filter, getMarketingTools, ngCopy) {
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.campaign = [];
    $scope.q = '';
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    var chartDate = [];
    var chartDataView = [];
    var chartDataReg = [];

    getCampaign();

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.campaign, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    $scope.noData = false;

    function getCampaign() {
      getMarketingTools.getCampaignData().then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.campaign = response.data.list;
        } else if (response.data.status === "noData") {
          $scope.noData = true;
          $scope.campaign = [];
        }
      }, function() {
        $scope.noData = true;
        $scope.campaign = [];
      });
    }

    $scope.changeAdState = function(c, type) {
      var data = {
        "request_type": "updateAdState",
        "bannerId": c.bannerId,
        "status": type
      };
      $http.post("../../core/functions/getMarketingTools", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          getCampaign();
        } else {
          swal("", "Error : unable to update campaign status", "warning");
        }
      }, function() {
        swal("", "Error : unable to update campaign status", "warning");
      });
    }

    $http.get("../../core/functions/getChartData").then(function(response) {
      if (response.status === 200 && response.data.status === "ok") {
        var obj = Object.keys(response.data.info).length;
        if (obj > 0) {
          for (var i = 0; i < obj; i++) {
            chartDate.push(response.data.info[i].date);
            chartDataView.push(response.data.info[i].vpd);
            chartDataReg.push(response.data.info[i].rpd);
          }
          $scope.adImp = response.data.view;
          $scope.adReg = response.data.reg;
          updateChartCamp();

        } else {
          chartDataView = [];
          chartDate = [];
          chartDataReg = [];
          updateChartCamp();
        }
      } else {
        chartDataView = [];
        chartDate = [];
        chartDataReg = [];
        updateChartCamp();
      }
    });

    function updateChartCamp() {
      Highcharts.chart('trackAdsCamp', {

        xAxis: {
          categories: chartDate,
          allowDecimals: false,
          title: {
            text: 'Date'
          }
        },

        title: {
          text: "Campaign Analytics",
          y: 20,
          margin: 25
        },

        credits: {
          enabled: false
        },

        series: [{
          name: "Impressions",
          data: chartDataView
        }, {
          name: "Registrations",
          data: chartDataReg
        }],

        yAxis: {
          title: {
            text: 'No of Client\'s'
          }
        }
      });
    }

  }]);

  dashboard.controller('paymentRequest', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED" || status === "APPROVED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED" || status === "CANCELLED" || status === "REJECTED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all" || sts === "All") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    getPaymentHistory();
    getWalletDetails();



    function getPaymentHistory() {
      var data = {
        "requestType": "paymentRequestHistory"
      };
      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    function getBankDetails() {
      var data = {
        "requestType": "getClientBankDetail"
      };
      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.bankDetails = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.bankDetails = [];
        } else {
          $scope.bankDetails = [];
        }
      }, function() {
        $scope.bankDetails = [];
      });
    }

    $scope.updateBankDetail = function(bank) {
      if (bank === undefined) {
        $scope.gatewayAccountIdInput = "";
      } else {
        $scope.gatewayAccountIdInput = bank.accountNumber;
        $scope.bankId = bank.id;
      }
    }

    $scope.getBankDetails = function(gateway) {
      if (gateway === "Bank Transfer") {
        getBankDetails();
      }
    }

    $scope.requestPayment = function() {
      $("#requestPaymentModal").modal("show");
    }

    $scope.checkBank = function(bank, gateway) {
      if (gateway !== "Bank Transfer") {
        return bank;
      } else {
        bank = JSON.parse(bank);
        return bank.bankName + "  -  " + bank.accountNumber;
      }
    }

    $scope.sendPaymentRequest = function(e) {
      e.preventDefault();
      if ($scope.withdrawAmount <= 0) {
        $scope.Erroramt = true;
      } else {
        $scope.Erroramt = false;
      }

      if ((parseFloat($scope.walletDetails.balance) - parseFloat($scope.withdrawAmount)) >= 0) {
        var data = {
          "requestType": "paymentRequest",
          "amt": $scope.withdrawAmount,
          "gateway": $scope.gateway,
          "gatwayAccountId": $scope.gatewayAccountIdInput,
          "BankID": $scope.bankId
        }

        $http.post("../../core/functions/paymentRequest", data).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            getPaymentHistory();
            getWalletDetails();
            $scope.withdrawAmount = "";
            $scope.gateway = "";
            $scope.gatewayAccountIdInput = "";
            $("#requestPaymentModal").modal("hide");
            swal("", "Your Request has been submitted", "success");
          } else if (response.data.status === "insufficientFund") {
            swal("", "Withdraw amount cannot be morethan available balance", "warning");
          } else {
            swal("", "Unable to submit your request, Please contact our support", "warning");
          }
        }, function() {
          swal("", "Unable to submit your request, Please contact our support", "warning");
        });
      } else {
        swal("", "Withdraw amount cannot be morethan available balance", "warning");
      }
    }

    function getWalletDetails() {

      var data = {
        "requestType": "getWalletDetails"
      };
      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.walletDetails = response.data.info;
        }
      }, function() {});

    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

    $scope.cancelPaymentProcess = function(detail) {
      var data = {
        "requestType": "cancelPaymentProcess",
        "batchId": detail.batchId
      };

      $http.post("../../core/functions/paymentRequest", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          getPaymentHistory();
          getWalletDetails();
          swal("", "Payment processing has been cancelled", "success");
        } else {
          if (detail.status !== 'pending') {
            swal("", "Cannot cancel payment process on the status of " + detail.status, "warning");
          } else {
            swal("", "unable to cancel payment, contact our support", "warning");
          }
        }
      }, function() {
        swal("", "unable to cancel payment, contact our support", "warning");
      });
    }

  }]);

  dashboard.controller('tradeAccounts', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', '$routeParams', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout, $routeParams) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.partnerEmail = $localStorage.client_details.email;
    $scope.userId = $routeParams.userId;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getTradeAccounts($scope.userId);

    function getTradeAccounts(userId) {
      var data = {
        'requestType': "getTradeAccounts",
        'uId': userId
      };

      $http.post("../../core/functions/getTradeAccounts", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('changePassword', ['$scope', '$timeout', '$http', '$location', '$window', '$localStorage', 'Auth', '$cookies', function($scope, $timeout, $http, $location, $window, $localStorage, Auth, $cookies) {

    $scope.checkPwd = function(pwd) {
      $scope.pwd = pwd;
      var pwdStrength = checkPasswordStrength(pwd);
      if (pwdStrength == "short" || pwdStrength == "weak") {
        $scope.bdrError = true;
      } else {
        $scope.bdrError = false;
      }

      if ($scope.password !== $scope.newPassword) {
        $scope.pwdMatch = true;
      } else {
        $scope.pwdMatch = false;
      }
    }

    $scope.resetPassword = function(e) {
      e.preventDefault();
      if (!$scope.bdrError) {
        var data = {
          "requestType": "changePassword",
          "newPassword": $scope.password,
          "oldPassword": $scope.oldPassword
        };
        $http.post("../../core/functions/changePassword", data).then(function(response) {
          if (response.status === 200 && response.data.status === "ok") {
            $scope.password = "";
            $scope.oldPassword = "";
            $scope.newPassword = "";
            swal("", "Password has been Changed", "success");
          } else {
            swal("", "Error : unable to reset password, Contact your admin", "warning");
          }
        }, function() {
          swal("", "Error : unable to reset password, Contact your admin", "warning");
        });
      } else {
        $scope.bdrError = true;
      }
    }

    function checkPasswordStrength(password) {
      if (password === undefined) {
        password = "i";
      } else {
        password = password;
      }
      var strength = 0
      if (password.length < 6) {
        return 'short';
      }

      if (password.length > 7) strength += 1;
      if (password.match(/([a-z].*[A-Z])|([A-Z].*[a-z])/)) strength += 1;
      if (password.match(/([a-zA-Z])/) && password.match(/([0-9])/)) strength += 1;
      if (password.match(/([!,%,&,@,#,$,^,*,?,_,~])/)) strength += 1;
      if (password.match(/(.*[!,%,&,@,#,$,^,*,?,_,~].*[!,%,&,@,#,$,^,*,?,_,~])/)) strength += 1;

      if (strength < 2) {
        return 'weak';
      } else if (strength == 2) {
        return 'good';
      } else {
        return 'strong';
      }
    }

  }]);

  dashboard.controller('tradeAccounts', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', '$routeParams', '$filter', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout, $routeParams, $filter) {
    var clientID = $routeParams.clientID;
    $scope.clientName = $routeParams.clientName;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getTradeAccounts(clientID);

    function getTradeAccounts(clientID) {
      var data = {
        "clientID": clientID
      };
      $http.post("../../core/functions/getTradeAccounts", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('ibRequest', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.partnerEmail = $localStorage.client_details.email;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    getCountryList();

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    function getCountryList() {
      $http.get("https://smib.alphabetafx.com/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients();

    function getClients() {
      $http.get("../../core/functions/getIBRequest").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.addClient = function() {
      $("#addNewIBT2").modal('show');
      $scope.client_name = '';
      $scope.client_number = '';
      $scope.client_address = '';
      $scope.client_email = '';
      $scope.client_country = '';
      $scope.client_username = '';
      $scope.userId = '';
      $scope.update = false;
    }

    $scope.addNewClient = function(e) {
      e.preventDefault();
      var data_ = {
        "requestType": "addNewClient",
        "name": $scope.client_name,
        "number": $scope.client_number,
        "address": $scope.client_address,
        "country": $scope.client_country.name,
        "code": $scope.client_country.dial_code || "+91",
        "email": $scope.client_email,
        "username": $scope.client_username,
        "partnerId": $scope.partnerId,
        "partnerEmail": $scope.partnerEmail
      };
      $http.post("../../core/functions/addNewIB", data_).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $("#addNewIBT2").modal('hide');
          $scope.client_name = '';
          $scope.client_number = '';
          $scope.client_address = '';
          $scope.client_email = '';
          $scope.client_country = '';
          $scope.client_username = '';
          swal("", "IB Request Submitted", "success");
          getClients();
        } else if (response.data.status === "duplicate_user") {
          swal("", "Client Already Exist", "warning");
        } else {
          swal("", "Unable to request IB Account", "error");
        }
      }, function() {
        swal("", "Unable to request IB Account", "error");
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('ibRequest', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.partnerEmail = $localStorage.client_details.email;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';
    getCountryList();

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    function getCountryList() {
      $http.get("https://ib.alphabetafx.com/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients();

    function getClients() {
      $http.get("../../core/functions/getIBRequest").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.addClient = function() {
      $("#addNewClient_").modal('show');
      $scope.client_name = '';
      $scope.client_number = '';
      $scope.client_address = '';
      $scope.client_email = '';
      $scope.client_country = '';
      $scope.client_username = '';
      $scope.userId = '';
      $scope.update = false;
    }

    $scope.addNewClient = function(e) {
      e.preventDefault();
      var data_ = {
        "requestType": "addNewClient",
        "name": $scope.client_name,
        "number": $scope.client_number,
        "address": $scope.client_address,
        "country": $scope.client_country.name,
        "code": $scope.client_country.dial_code || "+91",
        "email": $scope.client_email,
        "username": $scope.client_username,
        "partnerId": $scope.partnerId,
        "partnerEmail": $scope.partnerEmail
      };
      $http.post("../../core/functions/addNewIB", data_).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $("#addNewClient_").modal('hide');
          $scope.client_name = '';
          $scope.client_number = '';
          $scope.client_address = '';
          $scope.client_email = '';
          $scope.client_country = '';
          $scope.client_username = '';
          swal("", "IB Request Submitted", "success");
          getClients();
        } else if (response.data.status === "duplicate_user") {
          swal("", "Client Already Exist", "warning");
        } else {
          swal("", "Unable to request IB Account", "error");
        }
      }, function() {
        swal("", "Unable to request IB Account", "error");
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('smibChain', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$cookies', 'Excel', '$timeout', '$routeParams', '$filter', function($scope, jwtHelper, $http, $location, $window, $localStorage, $cookies, Excel, $timeout, $routeParams, $filter) {
    var smibID = $routeParams.smibID;
    $scope.smibName = $routeParams.smibName;
    $scope.smibID = smibID;
    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients(smibID);

    function getClients(smibID) {
      var data = {
        "smibID": smibID
      };
      $http.post("../../core/functions/getIBonSMIB", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

  }]);

  dashboard.controller('inviteClient', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    $scope.partnerId = $localStorage.client_details.partnerId;
    $scope.ref_code = $localStorage.client_details.ref_code;
    $scope.email = $localStorage.client_details.email;
  }]);

  dashboard.controller('uploadBankDetails', ['$scope', 'Upload', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, Upload, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    var pic = '';
    getBankDocs();
    getCountryList();

    $scope.uploadDoc = function(e, name, accNo, branch, code, country, accDetails) {
      e.preventDefault();
      var data = {
        "bankName": name,
        "accNo": accNo,
        "branch": branch,
        "code": code,
        "country": country.name,
        "dialCode": country.dial_code,
        "accDetails": accDetails
      };
      $scope.upload($scope.file, data);
    }

    $scope.upload = function(file, data) {
      Upload.upload({
        url: '../../core/functions/uploadBankDoc',
        data: {
          file: file,
          dataDetails: data
        }
      }).then(function(resp) {
        if (resp.status === 200) {
          var status = resp.data.status;
          switch (status) {
            case "no_file":
              swal("", "No File Selected", "warning");
              break;
            case "invalid_file":
              swal("", "Select valid image type", "warning");
              break;
            case "file_exist":
              swal("", "Image already exist", "warning");
              break;
            case "success":
              getBankDocs();
              $scope.bankName = "";
              $scope.accNo = "";
              $scope.branch = "";
              $scope.code = "";
              $scope.client_country = undefined;
              $scope.accDetails = "";
              swal("", "Bank Details Uploaded", "success");
              break;
            case "invalid_token":
              swal("", "Session Expired", "error");
              break;
            default:
              swal("", "Pass Book Doc not updated", "warning");
          }
        } else {
          swal("", "Update failed", "error");
        }
      }, function(resp) {
        swal("", "Update failed", "error");
      }, function(evt) {
        var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
      });
    };

    function getBankDocs() {
      var data = {
        "requestType": "getBankDetails"
      };
      $http.post("../../core/functions/getBankDocs", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.verDetails = response.data.info;
        } else {
          $scope.verDetails = [];
        }
      }, function() {
        $scope.verDetails = [];
      });
    }

    function getCountryList() {
      $http.get("https://ib.alphabetafx.com/dir/countryList.js").then(function(response) {
        $scope.countryList = response.data;
      }, function() {
        $scope.countryList = [];
      });
    }

    $scope.removeDoc = function(id) {
      var data = {
        "requestType": "removeDoc",
        "docId": id
      };
      $http.post("../../core/functions/getBankDocs", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          getBankDocs();
          swal("", "verification document removed", "success");
        } else {
          swal("", "error on removing verification document", "warning");
        }
      }, function() {
        swal("", "error on removing verification document", "warning");
      });
    }

  }]);

  dashboard.controller('ClientOnIB', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', '$routeParams', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout, $routeParams) {

    var clientID = $routeParams.clientID;
    $scope.clientName = $routeParams.clientName;

    $scope.currentPage = 0;
    $scope.pageSize = 50;
    $scope.details = [];
    $scope.q = '';

    $scope.setRows = function(rows) {
      $scope.pageSize = rows;
    }

    $scope.getSpan = function(status) {
      if (status !== null && status !== undefined) {
        status = status.trim().toUpperCase();
      } else {
        status = "error";
      }
      if (status === "LOW" || status === "CLOSE" || status === "ACTIVE" || status === "COMPLETED") {
        return "b1";
      } else if (status === "MEDIUM" || status === "INPROCESS" || status === "SUSPENDED" || status === "PENDING") {
        return "b2";
      } else if (status === "HIGH" || status === "OPEN" || status === "TERMINATED") {
        return "b3";
      } else {
        return "hide";
      }
    }

    /* ----- orderby and date filter init ---------*/
    $scope.datePicker = {
      startDate: null,
      endDate: null
    };
    $scope.rev = false;
    $scope.statusFun = function(sts) {
      if (sts === "all") {
        return undefined;
      } else {
        return sts;
      }
    }

    $scope.orderBy = function(sts) {
      $scope.rev = !sts;
    }

    $scope.getData = function() {
      return $filter('filter')($scope.details, $scope.q);
    }

    $scope.numberOfPages = function() {
      return Math.ceil($scope.getData().length / $scope.pageSize);
    }

    $scope.getTotalRows = function() {
      return $scope.getData().length;
    }
    var processMode = '';
    getClients(clientID);

    function getClients(clientId) {

      var data = {
        "clientID": clientId
      }

      $http.post("../../core/functions/getClientInfoonib", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.noDate = false;
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.noDate = true;
        } else {
          $scope.noDate = true;
        }
      }, function() {
        $scope.noDate = true;
      });
    }

  }]);

  dashboard.controller('tradingHistory', ['$scope', 'jwtHelper', '$http', '$location', '$window', '$localStorage', '$filter', '$cookies', 'Excel', '$timeout', function($scope, jwtHelper, $http, $location, $window, $localStorage, $filter, $cookies, Excel, $timeout) {
    getClientInfo();

    $scope.datePicker = {
      startDate: null,
      endDate: null
    };

    $scope.tabActive = 1;
    $scope.changeTab = function(tab) {
      $scope.tabActive = tab;
    }

    $scope.tradeHistory = [];
    $scope.tradeGroup = [];

    function getClientInfo() {
      $http.post("../../core/functions/getClientInfo").then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.details = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.details = [];
        } else {
          $scope.details = [];
        }
      }, function() {
        $scope.details = [];
      });
    }

    $scope.getTradeAccounts = function(email, id) {
      var data = {
        "clientID": id
      };
      $http.post("../../core/functions/getTradeAccounts", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          $scope.tradeAccounts = response.data.info;
        } else if (response.data.status === "noData") {
          $scope.tradeAccounts = [];
        } else {
          $scope.tradeAccounts = [];
        }
      }, function() {
        $scope.tradeAccounts = [];
      });
    }

    $scope.getHistory = function(platform, accountId) {
      var data = {
        "platform": platform,
        "login": accountId
      };
      $http.post("../../core/functions/trade_history", data).then(function(response) {
        if (response.status === 200 && response.data.status === "ok") {
          if (response.data.info === null) {
            $scope.tradeHistory = [];
          } else {
            $scope.tradeHistory = response.data.info;
          }

          if (response.data.infoGroup === null) {
            $scope.tradeGroup = [];
          } else {
            $scope.tradeGroup = response.data.infoGroup;
            groupChart(response.data.infoGroup);
          }
        } else if (response.data.status === "noData") {
          $scope.tradeHistory = [];
          $scope.tradeGroup = [];
        } else {
          $scope.tradeHistory = [];
          $scope.tradeGroup = [];
        }
      }, function() {
        $scope.tradeHistory = [];
        $scope.tradeGroup = [];
      });
    }

    $scope.exportToExcel = function(tableId) {
      var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
      $timeout(function() {
        location.href = exportHref;
      }, 100);
    }

    function groupChart(inputData) {
      var gData = [];
      for (var group in inputData) {
        var k = {
          "name": inputData[group].symbol,
          "y": inputData[group].totalLots
        };
        gData.push(k);
      }

      Highcharts.chart('groupSymbol', {
        chart: {
          plotBackgroundColor: null,
          plotBorderWidth: null,
          plotShadow: false,
          type: 'pie'
        },
        credits: {
          enabled: false
        },
        title: {
          text: 'Lots per Symbol Group'
        },
        tooltip: {
          pointFormat: '<b>{point.y} Lots</b>'
        },
        plotOptions: {
          pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
              enabled: false
            },
            showInLegend: true
          }
        },
        series: [{
          name: 'Lots',
          colorByPoint: true,
          data: gData
        }]
      });
    }

  }]);