<?php include('header.php');?>
    <main>
    

<section class="breadcrumb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ul>
                    <li>
                        <a href="index.php">Home</a>
                    </li>
                    <li>
                        <a>Legal Documents</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>
<section id="legal-documents-main">
    <div class="container page-title">
        <div class="row">
            <div class="col-12">
                <h1>Legal Documents</h1>
                <p>We offer you full transparency and want you to fully understand the implications of trading with Wizense Global.</p>
            </div>
        </div>
        <div class="row legal-documents-content">
            <div class="col-lg-4">
                <ul data-aos="fade-up">
                        <li id="terms-of-business" class="ld-list-items active" data-tab="2">
                            <a>Terms of Business</a>
                        </li>
                        <li id="privacy-policy" class="ld-list-items " data-tab="4">
                            <a>Privacy Policy</a>
                        </li>
                        <li id="risk-warning" class="ld-list-items " data-tab="3">
                            <a>Risk Warning</a>
                        </li>
                        <li id="cookie-policy" class="ld-list-items " data-tab="5">
                            <a>Cookie Policy</a>
                        </li>
                </ul>
            </div>
            <div class="col-lg-8 ldci-wrapper ld-scrollbar" data-scrollbar>
                    <div class="legal-documents-content-items active" data-tab="2" id="tob-scrollbar">
                        <img src="public/images/legal-documents/terms-of-business.png" alt="Terms of Business">
                        <div>
                            <h2>Terms of Business</h2>
                            <p>1. Subject of the agreement</p><p>1.1. This Client Agreement is entered into by Wizense Global Ltd (hereinafter referred to as “Company”) and the Client who submitted a registration form at www.wizensefx.com (hereinafter referred to as “Client”). Wizense Global is the trading name of Wizense Global Ltd.</p><p>1.2. The Company is registered and regulated and verned by the Law of Saint-Vincent and the Grenadines. Any legal claims will be a subject of the court hearings. Company’s legal address is First Floor, First St. Vincent Bank Ltd Building, James Street, Kingstown, St. Vincent and the Grenadines.</p><p>1.3. The Agreement sets forth the relationship between the Client and the Company including but not limited to: orders’ execution, Client policies, payments and/or payouts, claims resolution, fraud prevention, communication and other aspects.</p><p>1.4. Any possible arguments between the Client and the Company will be settled in compliance with the Agreement unless stated otherwise.</p><p>1.5. By entering into the Agreement the Client guarantees that he/she is a person of a legal age. In case the Client is a legal entity, it guarantees the entity is capable and no other parties are eligible to perform any actions, claims, demands, requests, etc. in respect to the Client’s trading account.</p><p>1.6. All the operations on and with the Client’s trading account are performed in full compliance with this Agreement unless stated otherwise</p><p>1.7. The Client has no right to bypass fully or partially his/her obligations by the Agreement on the basis that it is a distance contract.</p><p>2. Terms definition</p><p>2.1. “Access Data” denotes all the access logins and passwords related to Client’s trading account(s), Personal Area, or any other data providing access to any other Company’s services.</p><p>2.2. “Ask” denotes the higher price in the Quote at which the Client may open a “Buy” order.</p><p>2.3. "Autotrading Software" - denotes an Expert Advisor , that is, a piece of software which performs trading operations automatically or semi-automatically without interference (or with a partial or occasional interference) of a human.</p><p>2.4. “Balance” denotes the total of all the closed orders (including deposits and withdrawals) in the Client’s trading account at a given time.</p><p>2.5. “Base Currency” denotes the first currency in the Currency Pair.</p><p>2.6. “Bid” denotes the lower price in the Quote at which the Client may open a “Sell” order.</p><p>2.7. “Business Day” denotes any day between Monday and Friday, inclusive, except any official or non-official holidays announced by the Company.</p><p>2.8. “Client Terminal” denotes, MetaTrader 5 or any other software in all its versions, which is used by the Client to obtain information of financial markets in real-time, perform different kinds of market analysis and research, perform/open/close/ modify/delete orders, receive notifications from the Company.</p><p>2.9. “Currency of the Trading Account” denotes the currency that the Trading Account is denominated in; all the account’s calculations and operations are performed in this currency.</p><p>2.10. “Currency Pair” denotes the object of a transaction based on the change in the value of one currency against the other.</p><p>2.11. “Client Information” denotes any information that the Company receives from the Client (or in other ways) related to him/her, his /her trading account, etc.</p><p>2.12. “Dispute” denotes either:</p><p>2.12.1. any argument between the Client and the Company, where the Client has reasons to assume that the Company as a result of any action or failure to act breached one or more terms of the Agreement; or</p><p>2.12.2. any argument between the Client and the Company, where the Company has reasons to assume that the Client as a result of any action or failure to act breached one or more terms of the Agreement;</p><p>2.13. “Floating Profit/Loss” denotes current profit/loss on Open Positions calculated at the current price.</p><p>2.14. “Force Majeure Event” denotes any of the following events:</p><p>2.14.1. any act, event or occurrence (including, without limitation, any strike, riot or civil commotion, terrorism, war, act of d, accident, fire, flood, storm, electronic, communication equipment or supplier failure, interruption of power supply, civil unrest, statutory provisions, lock-outs) which, in the Company’s reasonable opinion, prevents the Company from maintaining an orderly market in one or more of the Instruments;</p><p>2.14.2. the suspension, liquidation or closure of any market or the abandonment or failure of any event to which the Company relates its Quotes, or the imposition of limits or special or unusual terms on the trading in any such market or on any such event.</p><p>2.15. “Free Margin” denotes funds in the Client’s account, which may be used to open a position. Free Margin is calculated in the following way:</p><p>&nbsp;</p><p>Free Margin = Equity - Required Margin.</p><p>2.16. "Index CFD" denotes a contract for difference by reference to the fluctuations in the price of the underlying stock index.</p><p>2.17. “Indicative Quote” denotes a price or a quote at which the Company has the right not to accept or execute any Orders or perform any modifications to the orders.</p><p>2.18. “Initial Margin” denotes the required margin to open a position.</p><p>2.19. “Instruction” denotes an instruction from the Client to open/ close a position or to place/modify/delete an Order.</p><p>2.20. “Instrument” denotes any Currency Pair, Metal, Commodity or Index CFD. It can be also referred to as “Trading Instrument” or “Trading Tool”</p><p>2.21. “Leverage” denotes the virtual credit given to the Client by the Company. E.g., 1:500 leverage means that Initial Margin for the Client will be 500 times less than the Transaction Size.</p><p>2.22. “Long Position” denotes a buy order, that is, buying the Base Currency against the Quote Currency.</p><p>2.23. "Lot" denotes 100000 units of the Base Currency, 1000 Barrels of Crude oil or any other number of contracts or troy oz. described in the Contract Specifications.</p><p>2.24. “Lot Size” denotes the number of units of Base Currency or troy oz. of Metal defined in the Contract Specifications.</p><p>2.25. “Margin” denotes the amount of funds required to maintain Open Positions, as determined in the Contract Specifications for each Instrument.</p><p>2.26. “Margin Level” denotes the percentage Equity to Required Margin ratio. It is calculated in the following way:</p><p>&nbsp;</p><p>Margin Level = (Equity /Required Margin) * 100%.</p><p>2.27. “Margin Trading” denotes Leverage trading when the Client may make Transactions having far less funds on the Trading Account compared to the Transaction Size.</p><p>2.28. “Open Position” denotes a Long Position or a Short Position which is not yet closed.</p><p>2.29. “Order” denotes an instruction from the Client to the Company to open or close a position when the price reaches the Order Level.</p><p>2.30. “Order Level” denotes the price indicated in the Order.</p><p>2.31. “Precious Metal” denotes spot ld or spot silver.</p><p>2.32. “Price Gap” denotes the following:</p><p>2.32.1. Current Bid price is higher than Ask of the previous Quote; or</p><p>2.32.2. Current Ask price is lower than Bid of the previous Quote.</p><p>2.33. “Quote” denotes the information of the current price for a specific Instrument, in the form of the Bid and Ask prices.&nbsp;</p><p>2.34. “Quote Currency” denotes the second currency in the Currency Pair which can be bought or sold by the Client for the Base Currency.</p><p>2.35. “Rate” denotes the following:</p><p>2.35.1. for the Currency Pair: the value of the Base Currency in the terms of the Quote Currency; or</p><p>2.35.2. for the Precious Metal: the price of one troy oz. worth of the Precious Metal against the US dollar or any other currency (if available) for this instrument; or</p><p>2.35.3. for the Index CFD: the price of one contract against the currency of the corresponding country.</p><p>2.36. “Required Margin” denotes the margin required by the Company to maintain Open Positions.</p><p>2.37. “Risk Disclosure” denotes the Risk Disclosure document.</p><p>2.38. “Segregated Account” denotes a bank account where the Clients’ funds are kept separately from the Company’s funds, as the regulations demand.</p><p>2.39. “Services” denotes any services provided by the Company to the Client.</p><p>2.40. “Short Position” denotes a sell position, that is, selling the Base Currency against the Quote Currency.</p><p>2.41. “Spread” denotes the difference between Ask and Bid prices.</p><p>2.42. “Trading Account” denotes the Client’s personal account in the Company at which the Client can perform orders, transactions, deposits, withdrawals, etc.</p><p>2.43. “Trading Platform” denotes all the Company’s software and hardware environment which provides real-time Quotes, allows Orders placing/modification/deletion/execution. Treading platform also calculates all the mutual obligations between the Client and the Company.</p><p>2.44. “Transaction Size” denotes Lot Size multiplied by number of Lots.</p><p>2.45. “Website” denotes the Company’s website at www.wizensefx.com.</p><p>3. Services</p><p>3.1. Subject to the Agreement, the Company will offer the following Services to the Client:</p><p>3.1.1. Receive and transmit trading orders or execute trading orders for the Client using the provided Trading Instruments.</p><p>3.2. Company’s services include MetaTrader 5 software packs, technical analysis means and any third parties’ services offered along with the Company’s services</p><p>3.3. Subject to the Agreement, the Company may enter into Transactions with the Client using the Trading Instruments specified on the Company’s website at www.wizensefx.com.</p><p>3.4. The Company shall carry out all Transactions with the Client on an execution only basis. The Company is entitled to execute Transactions notwithstanding that a Transaction may be not suitable for the Client. The Company is under no obligation, unless otherwise agreed, to monitor or advise the Client on the status of any Transaction; to make margin calls; or to close out any Client’s Open Positions.</p><p>3.5. The Client shall not be entitled to ask the Company to provide investment advice or to make any statements of opinion to encourage the Client to make any particular Transaction.</p><p>3.6. The Company shall not provide physical delivery of the Underlying Asset of an Instrument in relation to any Transaction. Profit or loss in the Currency of the Trading Account is credited/ debited from the Trading Account once the Transaction is closed.</p><p>3.7. The Company will not provide personal recommendations or advice on any specific Transactions.</p><p>3.8. The Company may from time to time and at its discretion provide information and recommendations in newsletters which it may post on its Website or provide to subscribers via its Website or otherwise. Where it does so:</p><p>3.8.1. This information is provided solely to enable the Client to make his own investment decisions and can’t be considered an investment advice;</p><p>3.8.2. If the document contains a restriction on the person or catery of persons for whom that document is intended or to whom it is distributed, the Client agrees that he will not pass it on to any such person or catery of persons;</p><p>3.8.3. Company gives no representation, warranty or guarantee as to the accuracy of completeness of such information or as to the tax consequences of any Transaction;</p><p>3.8.4. It is provided solely to assist the Client to make his/her own investment decisions and can’t be considered an investment advice or unsolicited financial promotions to the Client.</p><p>3.9. In providing the Client with reception and transmission and/or execution services the Company is not required to assess the suitability of the financial instrument in which the Client wishes to transact, nor the service(s) provided or offered to him.</p><p>3.10. The Company reserves the right, at its discretion, at any time to refuse to provide the Services to the Client and the Client agrees that the Company will have no obligation to inform the Client of the reasons.</p><p>3.11. The Company reserves a right to reject the Client by returning him/her his/her initial deposit (that is the total amount deposited by the Client) at any time, in case the Company deems it appropriate and necessary (including but not limited to as the result of Client’s malicious, illegal, inappropriate, fraudulent or in any other way inacceptable actions).</p><p>3.12. Market commentary, news, or other information is a subject to change and may be modified at any time without notice. The information can under no circumstances be considered as a direct or indirect trading advice.</p><p>3.13. Any trading decision made by the client is his/her sole responsibility. The company is not liable for consequences of such decisions.</p><p>3.14. By accepting this Agreement the Client confirms he/she has read the communication rules and agrees that he/she is only able to perform orders by means of the Client Terminal only.</p><p>3.15. The Client agrees that the Company can modify, add, rename or cancel any or the scope of the services offered in this Agreement partially or completely without prior notification. The Client also agrees that the Agreement is applied to the services which may be modified, added or renamed in future in addition to the services provided by the Company at present.</p><p>3.16. The Company is not liable to (unless set forth in this Agreement) attempt to execute any Client’s order at the quotes other than the quotes offered in the Trading Platform</p><p>3.17. The Company is under no circumstances a tax agent. The Parties comply with their tax and/or any other obligations independently and on their own.</p><p>4. Client orders and transactions</p><p>4.1. The Company provides Market Execution on all the trading instruments. The Company applies ECN/STP model to orders’ execution, that is, all the Client’s positions are offset to the interbank liquidity providers. In some cases the orders may fail to be offset, or the Company may solely decide not to offset an order or a group of orders.</p><p>4.2. As a result of the nature of the Market Execution, slippage during orders opening/closure may occur. The Client agrees that such possible occasional slippage is a natural consequence and feature of Market Execution and the Company is not responsible for it in any way.</p><p>4.3. Any possible open/close price deviation is a subject of the available liquidity. The Company bears no responsibility for the consequences of such deviations and/or price difference from the price requested by the Client.</p><p>4.4. The Client can cancel a sent order only while it is in queue with “Order is accepted” status. In this case the Client should press “Cancel order” button. Due to the specifics of the Client Terminal order cancellation in this case cannot be guaranteed.</p><p>4.5. The Client’s request to open/modify or close an order can be declined in the following cases:</p><p>4.5.1. During market opening when the order is sent before the first quote is received by the Trading Platform;</p><p>4.5.2. In exceptional market conditions;</p><p>4.5.3. In case the Client doesn’t have sufficient margin. In this case “Not enough money” or "Insufficient funds" message is displayed by the Trading Platform;</p><p>4.5.4. In case the Client uses an Autotrading Software performing over 30 requests per minute the Company reserves a right to ban such Expert Advisors;</p><p>4.6. The use of the same IP address by different clients can be a reason to consider all the orders in all the accounts, performed from this IP address, as those performed by the same Client;</p><p>4.7. Orders opened or closed by off-market quotes can be cancelled:</p><p>4.7.1. In case the order was opened by an off-market quote;</p><p>4.7.2. In case the order was closed by an off-market quote;</p><p>4.8. Using arbitrage strategies on linked markets (e.g. currency futures and spot currencies) is prohibited. In case the Client uses arbitrage in either clear or hidden way, the Company reserves a right to cancel such orders.</p><p>4.9. In exceptional cases short-term orders lasting less than 180 seconds can be cancelled should they be considered an abuse.</p><p>4.10. The Company reserves a right to cancel Client’s orders in case they do not comply with this Agreement.</p><p>4.11. In case the Client uses a swap-free account to perform arbitrage orders the Company reserves a right to change the account status back to regular and deposit/charge swaps for the whole period with prior written notification.</p><p>4.12. A buy order shall be opened by Ask price. A sell order shall be opened by Bid price.</p><p>4.13. A buy order shall be closed by Bid price. A sell order shall be closed by Ask price.</p><p>4.14. Swap addition/deduction to open orders is performed from 23:59:00 to 00:01:00, terminal time. So the swap charges (or, on the contrary, payouts) will be applied to all open orders during the period from 23:59:00 to 00:01:00, terminal time.</p><p>4.15. The Company reserves a right to increase spreads in case one or more of the following events occur:</p><p>4.15.1. In case the market conditions become irregular;</p><p>4.15.2. In case trading conditions for one or more currency pairs are changed;</p><p>4.15.3. In case of Force Majeure event(s);</p><p>5. Order processing</p><p>5.1. At the moment when Client’s order to open the position comes to the server, an automatic check of the trading account for free margin for the open order is carried out. In the event that the necessary margin is present, the order is opened. If the margin is not sufficient, the order is not opened. Due to Market execution an opening price may differ from the requested one. The note about the open order appearing on log-file of the server declares that Client’s request has been processed and the order has been opened. Each open order on the Trading Platform receives a ticker.</p><p>5.2. While opening an order on the market the Client shall not submit orders “Stop Loss” and “Take Profit” due to Market Execution. Setting “Stop Loss” and “Take Profit” is performed by modifying an open order</p><p>6. Mandatory position closure (Margin call and stop out)</p><p>6.1. Margin call occurs whenever account's margin level falls below a designated percentage described in the Trading Account specification on the Company Website. The Company is entitled but not liable to close Client positions in this case.</p><p>6.2. The Company is liable to mandatory close Client open positions without prior notification in case Margin level falls below the designated percentage described in the Trading Account specification on the Company Website. This event is called Stop Out.</p><p>6.3. Stop out is executed at a current market quote on a first-come-first-serve basis. Stop out will be fixed in server’s log-file as “stop out”.</p><p>6.4. In case the Client has several open positions, the first position to close will be the one with highest floating loss.</p><p>6.5. In case Stop Out leads to account balance becoming negative, this does not imply any debt payments from the Client and can’t be deemed as such. The Company will compensate the account balance to zero. In exceptional cases (should the Company deem Client’s actions as fraudulent or intentional) the debt may be claimed by the Company.</p><p>6.6 Margin Call and Stop Out levels may be increased during news releases, periods of high market volatility, abnormal market conditions and other irregular events.</p><p>7. Leverage modification</p><p>7.1. Leverage modification by the Client is only allowed once in every 24 hours.</p><p>7.2. The Company reserves a right to modify Client’s leverage settings at any time without prior notification.</p><p>7.3 The Company may at its discretion change the leverage of any account under circumstances different from the cases described in the Agreement should it be deemed necessary or appropriate.</p><p>8. Trading conditions</p><p>8.1. Complete trading conditions including but not limited to current spreads, currency pairs, lot sizes, transaction sizes, long and short swaps, commissions, volume and/or deposit limitations, account types, etc. is located at the Company’s website at www.wizensefx.com. The Company reserves a right to modify/add/cancel any or all of the trading conditions.</p><p>8.2. Any kind of abusing and/or taking unfair (direct or indirect) advantage of the Company’s trading conditions may be a subject of investigation. Should facts of such abuses arise, the profit and/or loss gained with this advantage may be canceled by the Company’s sole decision. The Client fully acknowledges this.</p><p>9. Pending orders</p><p>9.1. The following kinds of pending orders may be executed in the Trading Software:</p><p>9.1.1. Buy Limit – an order to open a “Buy” position if Ask price becomes lower or equal to the order price. The current price at the moment of placing an order is higher than the Buy Limit order price;</p><p>9.1.2. Buy Stop – an order to open a “Buy” position if Ask price becomes higher or equal to the order price. The current price at the moment of placing an order is lower than the Buy Stop order price;</p><p>9.1.3. Sell Limit – an order to open a “Sell” position if Bid price becomes higher or equal to the order price. The current price at the moment of placing an order is lower than the Sell Limit order price;</p><p>9.1.4. Sell Stop – an order to open a “Sell” position if Bid price becomes lower or equal to the order price. The current price at the moment of placing an order is higher than the Sell Stop order price;</p><p>9.1.5. “Stop Loss” – an order to close an open position at a certain price in case the position generates losses.</p><p>9.1.6. “Take Profit” – an order to close an open position at a certain price in case the position generates profit.</p><p>10. Orders’ rules</p><p>10.1. Opening, modification and deletion of orders is only allowed during active trading hours set forth in the Contracts Specification. Opening, modification and deletion of orders is not allowed beyond trading hours when trading is not allowed.</p><p>10.2. In the exceptional case of irregular market conditions, trading for a certain tool may be prohibited (fully or partially, temporarily or permanently) until the conditions remain irregular or until further notice.</p><p>10.3. All the pending orders are executed by GTC Model (“od Till Cancelled”) and have no period of validity, that is, they remain active until cancelled by the Client. The</p><p>10.4. In case one or several order parameters are invalid or missing, an order may be declined by the Trading Platform.</p><p>10.5. The Company at its sole discretion will specify the current market price.</p><p>10.6. Orders of all types shall not be placed closer than a stated number of points to the current price. The minimum distance in points from the current price may be varied with prior notice.</p><p>10.7. A note in server log-file about the order opening means the Client has opened an order and agrees with it. Each order receives a unique number (a ticker).</p><p>10.8. In case an order opening is requested before the first quote appears in the Trading Platform, it will be rejected by the Trading Platform. A message “No price/Trading is forbidden” will appear in the Client Terminal.</p><p>10.9. A note in server log-file about the order closure or modification means the Client has modified or closed an order and agrees with it.</p><p>10.10. In case an order closure or modification is requested before the first quote appears in the Trading Platform, it will be rejected by the Trading Platform.</p><p>11. Pending orders execution</p><p>11.1. A pending order is executed in the following cases:</p><p>11.1.1. Buy Limit order – whenever current Ask price becomes lower or equal to the order price;</p><p>11.1.2. Buy Stop order – whenever current Ask price becomes higher or equal to the order price;</p><p>11.1.3. Sell Limit order – whenever current Bid price becomes higher or equal to the order price;</p><p>11.1.4. Sell Stop order – whenever current Bid price becomes lower or equal to the order price;</p><p>11.1.5. Take Profit order for a “Buy” position – whenever current Bid price becomes equal or higher than the order price;</p><p>11.1.6. Stop Loss order for a “Buy” position – whenever current Bid price becomes equal or lower than the order price;</p><p>11.1.7. Take Profit order for a “Sell” position – whenever current Ask price becomes equal or lower than the order price;</p><p>11.1.8. Stop Loss order for a “Sell” position – whenever current ask price becomes equal or higher than the order price;</p><p>11.2. The following rules are applied to orders’ execution during price gaps:</p><p>11.2.1. In case pending order price and Take Profit level are within the price gap will be cancelled with a comment (cancelled/gap);</p><p>11.2.2. In case “Take Profit” order price is within the price gap, the order will be executed by its price;</p><p>11.2.3. In case “Stop Loss” order price is within the price gap, the order will be executed by the first price after the price gap with a comment (sl/gap);</p><p>11.2.4. “Buy Stop” and “Sell Stop” pending orders will be executed by the first price after the price gap with a comment (started/gap);</p><p>11.2.5. “Buy Limit” and “Sell Limit” pending orders will be executed by the order’s price with a comment (started/gap);</p><p>11.3. In certain cases when small price gaps occur, the orders may be executed as usual as stated in previous paragraph.</p><p>12. Margin requirements</p><p>12.1. The Client shall provide and maintain the Initial Margin and/or Hedged Margin in such limits as the Company, at its sole discretion, may require from time to time in compliance with the Agreement. It is the Client’s sole responsibility to ensure that the Client understands how margin is calculated.</p><p>12.2. The Client shall pay Initial Margin and/or Hedged Margin at the moment of opening a position.</p><p>12.3. If no Force Majeure Event has occurred, the Company is entitled to change margin requirements, giving to the Client 3 (three) Business Days Written Notice prior to these amendments.</p><p>12.4. The Company is entitled to change margin requirements without prior Written Notice in the case of Force Majeure Event.</p><p>12.5. The Company is entitled to apply new margin requirements amended in accordance with above mentioned paragraphs to the new positions and to the positions which are already open.</p><p>12.6. The Company is entitled to close the Client’s Open Positions without the consent of the Client or any prior Written Notice if the Equity is less than certain rate depending on the account type as stipulated on Company Website.</p><p>12.7. It is the Client’s responsibility to notify the Company as soon as the Client believes that the Client will be unable to meet a margin payment when due.</p><p>12.8. The Company is not obliged to make margin calls for the Client. The Company is not liable to the Client for any failure by the Company to contact, or attempt to contact the Client.</p><p>13. Deposit and withdrawal</p><p>13.1. The Client may deposit funds into the Trading Account at any time. All payments to the Company shall be made in accordance with the Payment Instructions set forth at the Company’s Website. Under no circumstances will third party or anonymous payments be accepted.</p><p>13.2. In case the nature of deposit means does not allow instant payment processing (bank wire, etc), the Client is to create a Deposit Request in the Personal Area. Failure to do so will lead to delays in account deposit.</p><p>13.3. It is the Client’s sole responsibility to create Deposit Requests in his/her Personal Area and to fill them in a correct and proper way. Failure to do so will lead to delays in account deposit.</p><p>13.4. The Client may withdraw funds from the Trading Account at any time in accordance with the procedures as described in paragraph 13.5.</p><p>13.5. If the Client requests to withdraw funds from the Trading Account, the Company shall pay the specified amount within three (3) Business Days once the request has been accepted, if the following conditions are met:</p><p>13.5.1. Withdrawal request contains all necessary information;</p><p>13.5.2. The request is to perform funds transfer to the Client’s bank account or e-currency account (under no circumstances will payments to third party or anonymous accounts be accepted); and</p><p>13.5.3. Client’s Free Margin exceeds or equals to the amount specified in the withdrawal request including all payment charges.</p><p>13.6. The Company shall debit the Client’s Trading Account for all payment charges (if applicable).</p><p>13.7. In case the account was deposited by various means, withdrawal shall be performed via the same means proportionally to the deposited amounts.</p><p>13.8. In exceptional cases (such as Force Majeure circumstances, termination of payment system operation, etc) Company is entitled to decline Client’s funds withdrawal in this payment system. Such cases shall be considered on a case by case basis.</p><p>13.9. To provide financial security for the Client in some cases the Company reserves a right to withdraw Client’s funds only to his/her bank account.</p><p>13.10. In case an account was funded via debit or credit card and a withdrawal request is submitted within 60 days from the date of deposit, the funds may be credited back to the same card. Up to 100% of the initial deposit may be withdrawn to the card. The amount over the initial deposit can be withdrawn via bank wire.</p><p>13.11. If an account was funded via debit or credit card, a card copy may be required to process a withdrawal. The copy must contain the first 6 digits and the last 4 digits of the card number, cardholder’s name, expiry date and cardholder’s signature.</p><p>13.12. For security reasons the Company reserves a right to demand Client’s complete identification data, such as ID copy, address proof copy, bank reference letter and other relevant documents, apostilled or certified by a notary. Should such demand be made by the Company, the Client will have 30 days to collect and send the full set of requested documents to the Company. In case the Client does not send the requested set of documents within the mentioned 30 days period, his account will be blocked without the ability to be reinstated, deposit(s) refunded. No profits will be paid or losses reimbursed for such accounts.</p><p>13.13. Internal transfers (that is, transfers from one trading account to another within the Company) between third parties are prohibited.</p><p>13.14. If the Client has the obligation to pay any amount to the Company which exceeds the Trading Account Equity the Client shall pay the amount of excess forthwith upon the obligation arising.</p><p>13.15. All incoming payments shall be credited to the Client’s Trading Account no later than one (1) Business day after funds are received by the Company.</p><p>13.16. The Client acknowledges and agrees that where an amount is due and payable to the Company in accordance with the Agreement and sufficient funds are not yet credited to the Client’s Trading Account, the Company shall be entitled to treat the Client as having failed to make a payment to the Company and to exercise its rights in compliance with the Agreement.</p><p>13.17. The Client shall make any margin payments or other payments due in US dollars, Euros, and other currencies accepted by the Company. The payment amount will be converted into the Currency of the Trading Account at the current market rate.</p><p>13.18. The Company is entitled but not obliged to cover deposit and withdrawal fees applied by Skrill (Moneybookers), Neteller, or any other payment processor. In cases the Company deems appropriate such fees can be charged from the client.</p><p>14. Commissions, charges and other costs</p><p>14.1. The Client shall be obliged to pay the Company the commissions, charges and other costs set out in the Agreement. The Company will display all current commissions, charges and other costs at its Website.</p><p>14.2. The Company may modify commissions, charges and other costs from time to time without prior notice. All changes in commissions, charges and other costs are displayed at the Company Website.</p><p>14.3. The Client undertakes to pay all possible stamp expenses relating to this Agreement and any documentation which may be required.</p><p>14.4. The Client shall be solely responsible for all filings, tax returns and reports on any Transactions which should be made to any relevant authority, whether vernmental or otherwise, and for payment of all taxes (including but not limited to any transfer or value added taxes), arising out of or in connection with any Transaction.</p><p>14.5. The Company is not liable to disclose any reports regarding profits, commissions and other fees received by Company from Client’s trading, unless stated otherwise by the Agreement.</p><p>14.6 By opening an account the Client unconditionally accepts all fees applicable to his/her account as per trading conditions described on the Company Website.</p><p>15. Communication</p><p>15.1. In order to communicate with the Client, the Company may use:</p><p>15.1.1. Client Terminal internal mail;</p><p>15.1.2. Email;</p><p>15.1.3. Telephone;</p><p>15.1.4. Company’s Live Chat;</p><p>15.1.5. SMS;</p><p>15.1.6. Mobile push notifications;</p><p>15.1.7. Web push notifications;</p><p>15.1.8. Instant messenger services (Viber, Telegram, Facebook Messenger, etc.);</p><p>15.2. Company will use contact details provided by the Client whilst opening the Trading Account and the Client agrees to accept any notices or messages from the Company at any time.</p><p>15.3. Any piece of information sent to the Client (documents, notices, confirmations, statements, etc.) shall be deemed received:</p><p>15.3.1. Within one hour after emailing it, if sent by email;</p><p>15.3.2. Immediately after sending it if sent by the Trading Platform internal mail;</p><p>15.3.3. Once the telephone conversation has been finished, if contacted by phone;</p><p>15.3.4. Within one hour after it has been posted on the Company News Webpage, if posted at the Company’s Website;</p><p>15.4. On the first day of each month the Company will send the Client a statement which includes all Transactions during the previous month. The Statement shall be sent by email.</p><p>15.5. Any telephone conversation between the Client and the Company may be recorded. All Instructions and Requests received by telephone will be binding as if received in writing. Any recordings shall be and remain the sole property of the Company and will be accepted by the Client as a conclusive evidence of the Instructions, Requests or other arising obligations. The Client agrees that the Company may deliver copies of transcripts of such recordings to any court, regulatory or vernment authority.</p><p>16. Dispute resolution</p><p>16.1. In case any conflict situation arises when the Client reasonably believes that the Company as a result of any action or failure to act breaches one or more terms of the Agreement, the Client has the right to file a complaint.</p><p>16.2. To file any complaint, the Client should email it to <a href="mailto:complaints@wizensefx.com" data-cfemail="f99a969489959098979a9cb9bbb6aaadb6b7b4bca19f81d79a9694d7">complaints@wizensefx.com</a></p><p>16.3. A complaint MUST contain:</p><p>16.3.1. First and Last name of the Client (or company name if the Client is a legal entity);</p><p>16.3.2. Client’s login details in the Trading Platform (i.e. Account number);</p><p>16.3.3. Details of when the conflict first arose (date and time in the Trading Platform time);</p><p>16.3.4. Ticker of the order in question;</p><p>16.3.5. Description of the conflict situation supported by the reference to the Agreement;</p><p>16.4. The complaint MUST NOT contain:</p><p>16.4.1. Affective appraisal of the conflict situation;</p><p>16.4.2. Offensive language;</p><p>16.4.3. Uncontrolled vocabulary;</p><p>16.5. The Company has the right to reject a complaint in case any of the above mentioned provisions are breached.</p><p>16.6. The Claim resolution term is set as 10 (ten) working days since the claim has been submitted. In occasional cases the term may be increased.</p><p>17. Server log file</p><p>17.1. The Server Log File is the most reliable source of information in case of any Dispute. The Server Log File has absolute priority over other arguments including the Client Terminal Log File as the Client Terminal Log File does not register every stage of the execution of the Client’s Instructions and Requests.</p><p>17.2. If the Server Log File has not recorded the relevant information to which the Client refers, the argument based on this reference may not be considered.</p><p>18. Indemnification</p><p>18.1. The Company may resolve all Disputes by ONLY:</p><p>18.1.1. Crediting/debiting the Client’s Trading Account;</p><p>18.1.2. Reopening erroneously closed positions; and/or</p><p>18.1.3. Deleting erroneously opened positions or placed Orders.</p><p>18.2. The Company has the right to choose the method of Dispute resolution at its sole discretion.</p><p>18.3. Disputes not mentioned in the Agreement will be resolved in accordance with the common market practice and at the sole discretion of the Company.</p><p>18.4. The Company shall not be liable to the Client if for any reason the Client has received less profit than had hoped for or has incurred a loss as a result of uncompleted action which the Client had intended to complete. This said, the Company will under no circumstances compensate any “lost profit”.</p><p>18.5. The Company shall not be liable to the Client in respect of any indirect, consequential or non-financial damage (emotional distress, etc.).</p><p>19. Rejection of complaint</p><p>19.1. In case the Client had been notified in advance by the Trading Platform internal mail or some other way of routine construction on the Server, complaints made in regard to any unexecuted Instructions or Requests which are given during such a construction period, are not accepted. The fact that the Client has not received a notice shall not be a reason to file a complaint.</p><p>19.2. Complaints regarding Order execution time are not accepted.</p><p>19.3. No Client complaints will be accepted in regard to the financial results of the orders opened or closed using temporary excess Free Margin on the Trading Account gained as a result of a profitable position (cancelled by the Company afterwards) or opened at an Off-market quote (Spike) or by any other reason.</p><p>19.4. In regard to all Disputes any references by the Client to the Quotes of other companies or information systems can not be taken into account.</p><p>19.5. The Client acknowledges that he/she will not be able to manage the position while the Dispute in regard to this position is being considered and no complaints in regard to this matter are accepted.</p><p>20. Force majeure</p><p>20.1. The Company may, in its reasonable opinion, determine that a Force Majeure Event exists, in which case the Company will, in due course, take reasonable steps to inform the Client. A Force Majeure Event includes without limitation:</p><p>20.2. Any act, event or occurrence (including, without limitation, any strike, riot or civil commotion, terrorism, war, act of d, accident, fire, flood, storm, interruption of power supply, electronic, communication equipment or supplier failure, civil unrest, statutory provisions, lock-outs) which, in the Company’s reasonable opinion, prevents the Company from maintaining an orderly market in one or more of the Instruments;</p><p>20.3. The suspension, liquidation or closure of any market or the abandonment or failure of any event to which the Company relates its Quotes, or the imposition of limits or special or unusual terms on the trading in any such market or on any such event.</p><p>20.4. In case the Company determines in its reasonable opinion that a Force Majeure Event exists (without prejudice to any other rights under the Agreement) the Company may without prior Written Notice and at any time take any of the following steps:</p><p>20.4.1. Increase margin requirements;</p><p>20.4.2. Close down any or all Open Positions at the prices which the Company shall consider in od faith to be appropriate;</p><p>20.4.3. Suspend or freeze or modify the application of any or all terms of the Agreement to the extent that the Force Majeure Event makes it impossible or impractical for the Company to comply with them; or</p><p>20.4.4. Take or omit to take all such other actions as the Company deems to be reasonably appropriate in the circumstances with regard to the position of the Company, the Client and other Clients.</p><p>21. Safety</p><p>21.1. The Client will not proceed and avoid proceeding in any action that could probably allow the irregular or unauthorized access or use of the Trading Platform. The Client accepts and understands that the Company reserves the right, at its sole discretion, to terminate or limit his access to the Trading Platform if it suspects that he allowed such use.</p><p>21.2. When using the Trading Platform the Client will not, whether by act or omission, do anything that will or may violate the integrity of the Platform or cause it to malfunction.</p><p>21.3. The Client is permitted to store, display, analyze, modify, reformat and print the information made available through the Trading Platform. The Client is not permitted to publish, transmit, or otherwise reproduce that information, in whole or in part, in any format to any third party without the Company’s consent. The Client may not alter, obscure or remove any copyright, trademark or any other notices that are provided on the Trading Platform.</p><p>21.4. The Client agrees to keep secret and not to disclose any Access Data to any third party.</p><p>21.5. The Client agrees to notify the Company immediately if he knows or suspects that his Access Data have or may have been disclosed to any unauthorized person.</p><p>21.6. The Client agrees to co-operate with any investigation the Company may conduct into any misuse or suspected misuse of his Access Data.</p><p>21.7. The Client accepts that he will be liable for all Orders given through and being logged in under his Access Data and any such Orders received by the Company shall be considered as received from the Client.</p><p>21.8. The Client acknowledges that the Company bears no responsibility for any unauthorized third persons obtaining access to information, including logins, passwords, electronic currency accounts access, emails, electronic addresses, electronic communication and personal data, when the above are transmitted, using the internet or other network communication facilities, post, telephone, during oral or written conversation or any other means.</p><p>21.9 The client unconditionally guarantees that the source of the funds used for trading with Wizense Global is legal and the funds were not received as a result of any illegal activity, fraud, money laundering or other illegal sources. Failure to comply with this rule will lead to account termination and a report to the legal authorities in all cases without exceptions. IN NO CIRCUMSTANCES the company or its partners and/or subsidiaries will bear any responsibility for any claims or complaints if such case arises.</p><p>22. Miscellaneous</p><p>22.1. The Company has the right to suspend the Client’s Trading Account at any time for any od reason with or without Written Notice to the Client.</p><p>22.2. In the event that a situation arises that is not covered by the Agreement, the Company will resolve the matter on the basis of od faith and fairness and, where appropriate, by taking such action as is consistent with market practice.</p><p>22.3. In case any term of the Agreement (or any part of it) shall be held by a court of competent jurisdiction to be unenforceable for any reason then such term shall, to that extent, be deemed severable and not form part of this Agreement. However, the enforceability of the remainder of the Agreement shall not be affected.</p><p>22.4. The Client may not assign, charge or otherwise transfer or purport to assign, charge or otherwise transfer the Client’s rights or obligations under the Agreement without prior written consent of the Company and any purported assignment, charge or transfer in violation of this term shall be voided.</p><p>22.5. Where the Client comprises two or more persons, the liabilities and obligations under any agreement with the Company shall be joint and several. Any warning or other notice given to one of the persons which form the Client shall be deemed to have been given to all the persons who form the Client. Any Order given by one of the persons who form the Client shall be deemed to have been given by all the persons who form the Client.</p><p>22.6. The Client accepts and understands that the Company’s official language is English, and the Client should always read and refer to the English Version of the Company’s Website for all information and disclosures about the Company and its activities. Translation or information provided in languages other than English in the Company’s local websites is for informational purposes only and does not bind the Company or has any legal effect whatsoever. The Company shall not bear any responsibility or liability regarding the correctness of the information therein.</p><p>23.MANIFEST ERROR</p><p>23.1 A manifest error can occur when a wrong price has been dealt on. This can be due to human error in the form of a misquote, or a computer fault.</p><p>23.2 Wizense Global may at its absolute discretion cancel, or amend, a trade or change the price that a trade has been dealt at if it believes that a manifest or palpable error has occurred.</p><p>23.3 If Wizense Global does change a price from the one dealt at, then it will do so to a fair price which represents where the price should have been at the time of the deal.</p><p>AML POLICY</p><p>Scope of policy</p><p>This policy applies to all Wizense Global officers, employees, appointed producers and products and services offered by Wizense Global. All business units and locations within Wizense Global will cooperate to create a cohesive effort in the fight against money laundering. Each business unit and location has implemented risk-based procedures reasonably expected to prevent, detect and cause the reporting of transactions. All efforts exerted will be documented and retained. The AML Compliance Committee is responsible for initiating Suspicious Activity Reports ("SARs") or other required reporting to the appropriate law enforcement or regulatory agencies. Any contacts by law enforcement or regulatory agencies related to the Policy shall be directed to the AML Compliance Committee.</p><p>The committee shall</p><p>Receive internal reports of (suspicions of) money laundering</p><p>Investigate reports of suspicious events</p><p>Make reports of relevant suspicious events to the relevant authorities</p><p>Ensure the adequacy of arrangements made for the awareness and training of staff and advisers</p><p>Report at least annually to the firm’s verning body on the operation and effectiveness of the firm’s systems and controls.</p><p>Monitor the day-to-day operation of anti-money laundering policies in relation to: the development of new products; the taking on of new customers; and changes in the firm’s business profile.</p><p>Policy</p><p>It is the policy of Wizense Global to actively pursue the prevention of money laundering and any activity that facilitates money laundering or the funding of terrorist or criminal activities. Wizense Global is committed to AML compliance in accordance with applicable law and requires its officers, employees and appointed producers to adhere to these standards in preventing the use of its products and services for money laundering purposes.</p><p>For the purposes of the Policy, money laundering is generally defined as engaging in acts designed to conceal or disguise the true origins of criminally derived proceeds so that the unlawful proceeds appear to have been derived from legitimate origins or constitute legitimate assets.</p><p>What is Money Laundering?</p><p>Money laundering is the process by which criminally obtained money or other assets (criminal property) are exchanged for “clean” money or other assets with no obvious link to their criminal origins.</p><p>Criminal property may take any form, including money or money’s worth, securities, tangible property and intangible property. It also covers money, however come by, which is used to fund terrorism.</p><p>Money laundering activity includes:&nbsp;</p><p>Acquiring, using or possessing criminal property</p><p>Handling the proceeds of crimes such as theft, fraud and tax evasion</p><p>Being knowingly involved in any way with criminal or terrorist property</p><p>Entering into arrangements to facilitate laundering criminal or terrorist property</p><p>Investing the proceeds of crimes in other financial products</p><p>Investing the proceeds of crimes through the acquisition of property/assets</p><p>Transferring criminal property.</p><p>There is no single stage of money laundering; methods can range from the purchase and resale of luxury items such as a car or jewelry to passing money through a complex web of legitimate operations. Usually the starting point will be cash, but it is important to appreciate that money laundering is defined in terms of criminal property. This can be property in any conceivable legal form, whether money, rights, real estate or any other benefit, if you know or suspect that it was obtained, either directly or indirectly, as a result of criminal activity and you do not speak up then you too are taking a part in the process.&nbsp;</p><p>The money laundering process follows three stages:&nbsp;</p><p>1.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Placement</p><p>Disposal of the initial proceeds derived from illegal activity e.g. into a bank account.</p><p>2.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Layering</p><p>The money is moved through the system in a series of financial transactions in order to disguise the origin of the cash with the purpose of giving it the appearance of legitimacy.</p><p>3.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Integration</p><p>Criminals are free to use the money as they choose once it has been removed from the system as apparently “clean” funds.</p><p>No financial sector business is immune from the activities of criminals and Firms should consider the money laundering risks posed by the products and services they offer.&nbsp;</p><p>What is Counter Terrorist Financing (CTF)?</p><p>Terrorist financing is the process of legitimate businesses and individuals that may choose to provide funding to resource terrorist activities or organizations for ideological, political or other reasons. Firms must therefore ensure that: (i) customers are not terrorist organizations themselves; and (ii) they are not providing the means through which terrorist organizations are being funded.&nbsp;</p><p>Terrorist financing may not involve the proceeds of criminal conduct, but rather an attempt to conceal the origin or intended use of the funds, which will later be used for criminal purposes.</p><p>Risk Based Approach</p><p>The level of due diligence required when considering anti-money laundering procedures within the firm, it should take a risk-based approach. This means the amount of resources spent in conducting due diligence in any one relationship that is subject risk should be in proportion to the magnitude of the risk that is posed by that relationship.&nbsp;</p><p>These can be broken down into the following areas:</p><p>Customer Risk</p><p>Different customer profiles have different levels of risks attached to them. A basic Know your Customer (KYC) check can establish the risk posed by a customer. For example, near-retired individuals making small, regular contributions to a savings account in line with their financial details poses less of a risk than middle-aged individuals making ad-hoc payments of ever-changing sizes into a savings account that does not fit into the profile of the customers’ standing financial data. The intensity of the due diligence conducted on the latter would be higher than that carried out on the former as the potential threat of money laundering in the second case would be perceived as being greater. Corporate structures can be used as examples of customers that could carry a higher risk profile than the one just seen, as these can be used by criminals to introduce layers within transactions to hide the source of the funds, and like that, clients can be caterized into different risk bands.&nbsp;</p><p>Product Risk</p><p>This is the risk posed by the product or service itself. The product risk is driven by its functionality as a money laundering tool.&nbsp;</p><p>The Joint Money Laundering Steering Group has caterized the products with which Firms typically deal into three risk bands – reduced, intermediate and increased. Typically, pure protection contracts are caterized as reduced risk and investments in unit trusts as increased risk. Additionally, a factor that will contribute to the classification of the risk catery is sales process associated with the product. If the transaction in the product takes place on an advisory basis as a result of a KYC, this will carry less risk than an execution only transaction, whereby you know significantly less about the customer.&nbsp;</p><p>Country Risk</p><p>The geographic location of the client or origin of the business activity has a risk associated with it, this stems from the fact that countries around the globe have different levels of risk attached to them.&nbsp;</p><p>A firm would determine the extent of their due diligence measure required initially and on an oning basis using the above four risk areas.</p><p>Customer identification program</p><p>Wizense Global has adopted a Customer Identification Program (CIP). Wizense Global will provide notice that they will seek identification information; collect certain minimum customer identification information from each customer, record such information and the verification methods and results.</p><p>Notice to customers</p><p>Wizense Global will provide notice to customers that it is requesting information from them to verify their identities, as required by applicable law.</p><p>Know your customer</p><p>When a business relationship is formed, in order to establish what might constitute normal activity later in the relationship, it is necessary for the company to ascertain the nature of the business a client expects to conduct.&nbsp;</p><p>Once an on-ing business relationship has been established, any regular business undertaken for that customer can be assessed against the expected pattern of activity of the customer. Any unexplained activity can then be examined to determine whether there is a suspicion of money laundering or terrorist financing.</p><p>Information regarding a client’s income, occupation, source of wealth, trading habits and the economic purpose of any transaction is typically gathered as part of the provision of advice. At the start of the relationship personal information is also obtained, such as, nationality, date of birth, and residential address. These pieces of information should also be considered in respect to the risk of financial crime (including AML and CTF). For high risk transactions, it might be appropriate to seek verification of the information the client has provided.</p><p>Source of Funds</p><p>When a transaction takes place, the source of funds, i.e. how the payment is to be made, from where and by who, must always be ascertained and recorded in the client file (this would usually be achieved through retaining a copy of the cheque or direct debit mandate).&nbsp;</p><p>Identification</p><p>The standard identification requirement for customers who are private individuals are generally verned by the circumstances relating to the customer and the product type that is being dealt in, i.e. the level of risk attributed to the product whether it is a reduced risk, intermediate risk or an increased risk product. Taking that into account for reduced risk and intermediate risk products the following pieces of information are required as a standard for identification purposes:&nbsp;</p><p>Full Name</p><p>Residential Address</p><p>Verification</p><p>Verification of the information obtained must be based on reliable and independent sources – which might either be documents produced by the customer, or electronically by the firm, or by a combination of both. Where business is conducted face-to-face, firms should see originals of any documents involved in the verification.&nbsp;</p><p>If documentary evidence of an individual’s identity is to provide a high level of confidence, it will typically have been issued by a vernment department or agency, or by a court, because there is a greater likelihood that the authorities will have checked the existence and characteristics of the persons concerned. In cases where such documentary evidence of identity may not be available to an individual, other evidence of identity may give the firm reasonable confidence in the customer’s identity, although the firm should weigh these against the risks involved.&nbsp;</p><p>If the identity is to be verified from documents, this should be based on:&nbsp;</p><p>Either a vernment issued document which incorporates:&nbsp;</p><p>The customer’s full name, and</p><p>Their residential address</p><p>Photographic vernment Issued Identity Documents</p><p>Valid passport</p><p>National Identity card</p><p>Alternatively, this can be done by a non-photographic vernment issued document which incorporates the customer’s full name, supported by a second document, which incorporates:&nbsp;</p><p>The customer’s full name, and</p><p>Their residential address</p><p>Evidence of Address</p><p>Current bank statements, or credit/debit card statements, issued by a regulated financial sector firm (but not ones printed off the internet and not less than 6 months old)</p><p>Utility bills (not including mobile phone bills, not ones printed off the internet and not less than 6 months old)</p><p>For increased risk level products, in addition to obtaining the standard information detailed above, the following know your customer information should be obtained and recorded:&nbsp;</p><p>Employment and income details</p><p>Source of wealth (i.e. source of the funds being used in the transaction)</p><p>Monitoring and reporting</p><p>Transaction based monitoring will occur within the appropriate business units of Wizense Global. Monitoring of specific transactions will include but is not limited to transactions aggregating $5,000 or more and those with respect to which Wizense Global has a reason to suspect suspicious activity. All reports will be documented.</p><p>Suspicious activity</p><p>There are signs of suspicious activity that suggest money laundering. These are commonly referred to as "red flags." If a red flag is detected, additional due diligence will be performed before proceeding with the transaction. If a reasonable explanation is not determined, the suspicious activity shall be reported to the AML Compliance Committee.&nbsp;</p><p>Examples of red flags are:</p><p>The customer exhibits unusual concern regarding the firm's compliance with vernment reporting requirements and the firm's AML policies, particularly with respect to his or her identity, type of business and assets, or is reluctant or refuses to reveal any information concerning business activities, or furnishes unusual or suspect identification or business documents.</p><p>The customer wishes to engage in transactions that lack business sense or apparent investment strategy, or are inconsistent with the customer's stated business strategy.</p><p>The information provided by the customer that identifies a legitimate source for funds is false, misleading, or substantially incorrect.</p><p>Upon request, the customer refuses to identify or fails to indicate any legitimate source for his or her funds and other assets.</p><p>The customer (or a person publicly associated with the customer) has a questionable background or is the subject of news reports indicating possible criminal, civil, or regulatory violations.</p><p>The customer exhibits a lack of concern regarding risks, commissions, or other transaction costs.</p><p>The customer appears to be acting as an agent for an undisclosed principal, but declines or is reluctant, without legitimate commercial reasons, to provide information or is otherwise evasive regarding that person or entity.</p><p>The customer has difficulty describing the nature of his or her business or lacks general knowledge of his or her industry.</p><p>The customer attempts to make frequent or large deposits of currency, insists on dealing only in cash equivalents, or asks for exemptions from the firm's policies relating to the deposit of cash and cash equivalents.</p><p>For no apparent reason, the customer has multiple accounts under a single name or multiple names, with a large number of inter-account or third-party transfers.</p><p>The customer's account has unexplained or sudden extensive activity, especially in accounts that had little or no previous activity.</p><p>The customer's account has a large number of wire transfers to unrelated third parties inconsistent with the customer's legitimate business purpose.</p><p>The customer's account has wire transfers that have no apparent business purpose to or from a country identified as money laundering risk or a bank secrecy haven.</p><p>The customer's account indicates large or frequent wire transfers, immediately withdrawn by check or debit card without any apparent business purpose.</p><p>The customer makes a funds deposit followed by an immediate request that the money be wired out or transferred to a third party, or to another firm, without any apparent business purpose.</p><p>The customer makes a funds deposit for the purpose of purchasing a long-term investment followed shortly thereafter by a request to liquidate the position and transfer of the proceeds out of the account.</p><p>The customer requests that a transaction be processed in such a manner to avoid the firm's normal documentation requirements.</p><p>Know your customer – the basis for recognizing suspicions</p><p>A suspicious transaction will often be one which is inconsistent with a customer's known, legitimate business or personal activities or with the normal business for that type of customer. Therefore, the first key to recognition is knowing enough about the customer's business to recognize that a transaction, or series of transactions, is unusual.&nbsp;</p><p>Questions you must consider when determining whether an established customer’s transaction might be suspicious are:&nbsp;</p><p>Is the size of the transaction consistent with the normal activities of the customer?</p><p>Is the transaction rational in the context of the customer’s business or personal activities?</p><p>Has the pattern of transactions conducted by the customer changed?</p><p>Suspicious scenarios</p><p>Issues which should lead you to have cause for suspicion would include:&nbsp;</p><p>Clients who are reluctant to provide proof of identity;</p><p>Clients who place undue reliance on an introducer (they may be hiding behind the introducer to avoid giving you a true picture of their identity or business);</p><p>Requests for cash related business, for example questions about whether investments can be made in cash, suggestions that funds might be available in cash for investment;</p><p>Where the source of funds for investment is unclear;</p><p>Where the magnitude of the available funds appears inconsistent with the client’s other circumstances (i.e. the source of wealth is unclear). Examples might be students or young people with large amounts to invest;</p><p>Where the transaction doesn’t appear rational in the context of the customer’s business or personal activities. Particular care should be taken in this area if the client changes their method of dealing with you without reasonable explanation;</p><p>Where the pattern of transactions changes;</p><p>Where a client who is undertaking transactions that are international in nature does not appear to have any od reason to be conducting business with the countries involved (e.g. why do they hold monies in the particular country that the funds are ing to or from? Do their circumstances suggest that it would be reasonable for them to hold funds in such countries?);</p><p>Clients who are unwilling to provide you with normal personal or financial information, for no apparent or rational reason. (Care should be taken not to include all distance relationships as suspicious, because most will be for genuine reasons. Suspicions will ordinarily be based upon cumulative as opposed to stand alone issues)</p><p>A money launderer is likely to provide persuasive arguments about the reasons for their transactions. Those should be questioned to decide whether a transaction is suspicious.&nbsp;</p><p>Reporting a Suspicion</p><p>Where, for whatever reason, we suspect that a client, or anybody for whom they are acting, may be undertaking (or attempting to undertake) a transaction involving the proceeds of any crime it must be reported as soon as practicably possible and in writing.</p><p>Internal reports must be made regardless of whether any business was, or is intended to be, actually written.</p><p>Investigation</p><p>Upon notification to the AML Compliance Committee an investigation will be commenced to determine if a report should be made to the appropriate law enforcement or regulatory agencies. The investigation will include, but not necessarily be limited to, review of all available information, such as payment history, birth dates, and address. If the results of the investigation warrant, a recommendation will be made to the AML Compliance Committee to file the SAR with the appropriate law enforcement or regulatory agency. The AML Compliance Committee is responsible for any notice or filing with law enforcement or regulatory agency.</p><p>Investigation results will not be disclosed or discussed with anyone other than those who have a legitimate need to know. Under no circumstances shall any officer, employee or appointed agent disclose or discuss any AML concern, investigation, notice or SAR filing with the person or persons subject of such, or any other person, including members of the officer's, employee's or appointed agent's family.</p><p>Freezing of Accounts</p><p>Where we know that the funds in an account derive from criminal activity, or that they arise from fraudulent instructions, the account must be frozen. Where it is believed that the account holder may be involved in the fraudulent activity that is being reported, then the account may need to be frozen.&nbsp;</p>
                        </div>
                    </div>
                    <div class="legal-documents-content-items " data-tab="4" id="tob-scrollbar">
                        <img src="public/images/legal-documents/privacy-policy.png" alt="Privacy Policy">
                        <div>
                            <h2>Privacy Policy</h2>
                            <p>Wizense Global (“the company”) places a high priority on the privacy of clients, both present and former. This Privacy Policy describes how the company collects, uses, and protects the personal information of the clients. The client is not required to furnish any additional information beyond that, which has already been provided to the company. This Privacy Policy explains the manner in which we collect and maintain nonpublic information about our clients (such as your full name, mailing address, identification number, passport, driver’s license, etc., henceforth "information").</p><p>By providing information, the client gives his/her consent to collect, use, and store the information in the manner explained herein. By visiting the website and using the company’s services, the client acknowledges and agrees with this Privacy Policy.</p><p>Collection of personal information</p><p>The company collects information from the client when he/she:</p><p>a) opens an account and provides information through electronic registration forms;</p><p>b) makes a transaction including when he/she deposits and withdraws funds.</p><p>Additionally, from time to time, the company may collect information about its clients from third-party entities, such as information about the client’s credit history agencies. The information the company collects directly from the client may include information required to communicate with the client, such as address, phone number, and e-mail. Furthermore, the company may collect other identifiable information, such as identification numbers and/or passport/tax registration number and also demographic information, such as ZIP code, age, gender, birth date, etc.</p><p>Use of personal information</p><p>To personalize the client’s experience</p><p>The client information helps the company better respond to his/her individual needs.</p><p>&nbsp;To improve the website</p><p>The company continually strives to improve the website’s offerings based on the information and the feedback the company receives from the client.</p><p>&nbsp;To improve client service</p><p>The client information helps the company more effectively respond to client service requests and support needs.</p><p>&nbsp;To administer a contest, promotion, survey, or other site feature</p><p>&nbsp;To send periodic emails</p><p>Sharing information</p><p>The company does not disclose or share information about any of its clients (whether active or inactive) to any affiliated third parties or non-affiliated third parties other than in the manners and the entities set forth below:</p><p>To service providers for the purpose of opening, operating, and servicing the client’s account. Such service providers may include attorneys, accountants, auditors, financiers, introducing brokers for translation services, and other professionals.</p><p>To protect against fraud, unauthorized transactions (such as money laundering), claims, or other liabilities.</p><p>Use of cookies</p><p>A cookie is a small piece of data sent from a website and stored in a client’s web browser while the client is visiting the website. Cookies store information such as passwords (encrypted), usernames, shopping cart, certain preferences, etc. allowing visitors to visit sites repeatedly without having to enter the same information over and over. The company uses cookies to gather information about the client’s access to the website and other services the company provides.</p><p>Security and integrity of information</p><p>The company implements a variety of security measures to maintain the safety of the client’s personal information. The company uses Secure Socket Layer (SSL) encryption technology in order to protect certain information that the client submits. This type of technology protects the client from having his/her information intercepted by anyone other than the company. The company also uses other safeguards such as firewalls, authentication systems (e.g., passwords and personal identification numbers), and access control mechanisms to control unauthorized access to systems and data. The company restricts access to information at its offices so that only officers and/or employees who need to know the information have access to it.</p><p>Links</p><p>The website may contain links to other websites on the internet. The company is not responsible for the contents of those sites or for any other privacy practices on those internet sites. The client should read the terms of use and the privacy statements of any website that he/she may link to from the company website.</p><p>Acceptance by the client</p><p>Being the client of the company and actively using its services, its software and/or hardware that allow carrying out professional activity on the financial markets, the client accepts the Privacy Policy described in the present Privacy Policy.</p>
                        </div>
                    </div>
                    <div class="legal-documents-content-items " data-tab="3" id="tob-scrollbar">
                        <img src="public/images/legal-documents/risk-warning.png" alt="Risk Warning">
                        <div>
                            <h2>Risk Warning</h2>
                            <p>Wizense Global Ltd , First Floor, First St. Vincent Bank Ltd Building, James Street, Kingstown, St. Vincent and the Grenadines., is incorporated under registered number 909 LLC 2021 by the Registrar of Limited Liability Companies, registered by the Financial Services Authority of Saint Vincent and the Grenadines.</p><p>Wizense Global is the trading name of Wizense Global Ltd.</p><p>In this notice, we provide you with information to help you understand the nature and risks of our products and services. However, this Risk Disclaimer does not disclose all the risks and other significant aspects of Forex, CFDs and CFD Stocks. You should not engage in our products unless you understand the nature of the Over The Counter (OTC) Derivative trading, how it works, how you make a profit or loss and the extent of your exposure to risk and loss. If you are in any doubt you should seek professional advice. Please be advised that financial instruments offered by Wizense Global may be not suitable or appropriate for many clients.</p><p>You should not enter CFD Margin Trades unless you fully understand the risks involved. When deciding whether to trade in such instruments you should be aware of the following:</p><p>NOT ADVICE</p><p>We do not provide investment, tax, legal, regulatory or financial advice. Any information we provide to you, including any information provided by our client services team, is purely factual and does not take into account your personal circumstances.</p><p>Any decision to use our products is solely your decision, therefore you may wish to obtain independent professional advice from a suitably qualified advisor on any investment, financial, legal, regulatory, tax or similar matter before dealing with us.</p><p>LEVERAGE</p><p>Leverage enables you to enter into trades with a small deposit (also called margin) in terms of the overall contract value. However, this means a small movement in the underlying market can have a disproportionately dramatic effect on your trade. Even a small movement in the underlying market may result in the loss of your entire margin amount.&nbsp;</p><p>CURRENCY RISK</p><p>If you trade in a market denominated in a currency other than your base currency, currency exchange fluctuations may impact your profits and losses.</p><p>COSTS AND CHARGES</p><p>Before you enter into a Transaction you should make sure you have read and understood our costs and charges. Our costs and charges can be found on our website.</p><p>STOP ORDERS, GAPPING</p><p>Making a stop loss order may limit your loss but this is not guaranteed. Your loss may be greater in some circumstances. Slippage (also called 'gapping'); occurs when the market moves past the price at which you have set your stop loss order.</p><p>OUT OF HOUR MARKETS</p><p>During the out-of-hours sessions on index markets, our quotations reflect our own view of the prospects for a market. This could include referring to price movements in other relevant markets which are open. Furthermore, business done by other clients may itself affect our quotations. There may be nothing against which to measure our quotation at these times.</p><p>TECHNICAL RISKS</p><p>When executing trading operations through the client terminal, the Client shall assume the risk of financial loss, which can be caused by the failure of Client hardware, software and internet connection, the improper operation of Client equipment, the wrong settings in the client terminal, delayed client terminal updates, or the Client’s ignorance of the applicable rules described in the MetaTrader User Guide and in the Help section.</p>
                        </div>
                    </div>
                    <div class="legal-documents-content-items " data-tab="5" id="tob-scrollbar">
                        <img src="public/images/legal-documents/cookie-policy.png" alt="Cookie Policy">
                        <div>
                            <h2>Cookie Policy</h2>
                            <p>Understanding how and why we use cookies</p><p>We use cookies on our site to distinguish you from other users of our website. This helps us to provide you with a od experience when you browse our website and also allows us to improve and monitor use of our site.</p><p>This Cookie Policy explains what cookies are, how we use them and what benefits they may bring.</p><p>By continuing to use our website, you are agreeing to our use of Cookies on this site.</p><p>What are cookies?</p><p>A Cookie is a small file of letters and numbers that are sent to and stored on your computer, smart phone or other device for accessing the internet, whenever you visit a website if you agree.</p><p>Cookies contain information that is transferred to your computer’s hard drive. Cookies are useful because they allow a website to recognize a user’s device. More information about cookies can be found on http://www.allaboutcookies.org</p><p>Our cookies</p><p>We use or may use the following cookies:</p><p>Strictly necessary cookies:</p><p>These are cookies that are required for the operation of our website. They include, for example, cookies that enable you to log into secure areas of our website, such as the Client Login, our Demo Account Page or on our Research Centre.</p><p>Analytical/performance cookies:</p><p>These allow us to recognize and count the number of visitors, see how visitors move around our website when they are using it and estimate and report our total audience size and traffic. This help would help us to improve the way our website works, e.g., by ensuring that users are finding what they are looking for easily. All information about how you used our website is collected anonymously.</p><p>The service we use is ogle Analytics, a web analytics service provided by ogle. For more details please visit the ogle Privacy Centre. You can also watch a video about ogle Analytics Cookies.</p><p>Functionality cookies:</p><p>These are used to recognize you when you return to our website, when completing online forms and logging in to the site. This would enable us to personalize our content for you and remember your search preferences.</p><p>Session Cookie:</p><p>These are used where you log in to an application and it remembers that you are logged in as you navigate the website, e.g. where you apply online for an account with Wizense Global. When you close the browser the cookie is deleted, as a result when visiting the website again you would need to log in again.</p><p>Third parties</p><p>Please note that third parties (including, for example, executing brokers or providers of external services like web traffic analysis services) may also use cookies, over which we have no control.</p><p>When we include links to other websites, please bear in mind they will have their own privacy and cookie policies that will vern the use of any information you submit. We recommend you read their policies as Wizense Global is not responsible or liable for their privacy practices.</p><p>User agreement</p><p>By continuing to use our site, you agree to the placement of cookies on your device. If you choose not to receive our cookies, we cannot guarantee that your experience will be as fulfilling as it would otherwise be.</p><p>How to manage your cookies</p><p>The browsers of most computers, smart phones and other web-enabled devices are typically set up to accept cookies. If you wish to amend your cookie preferences and block cookies for this website or any other websites, you can do this through your browser settings. Your browser’s ‘help’ function will tell you how to do this.</p><p>However, please remember that if you choose to switch certain cookies off, it is likely to affect how our website works. For example, if you reject all cookies, you will not be able to use Wizense Global services that require you to “log in,” and you may not be able to take full advantage of all offerings. For more information about how to disable cookies, visit: http://www.allaboutcookies.org</p>
                        </div>
                    </div>
            </div>
        </div>
    </div>
</section>



    </main>
   <?php include('footer.php');?>