<?php include('header.php') ?>



    
    <section class="hero-mini-banner policy" style="
            background: url(assets/img/policy-bg.png) no-repeat;
            background-size: cover;
            background-position: center;
            ">
        <div class="container">
            <div class="banner-content text-center max-w-100">
                <h1 class="text-white display-3 font-weight-bold mb-3">
                    AML Policy
                </h1>
            </div>
        </div>
    </section>
    

    
    <section class="policy-content-section theme-padding bg-white">
        <div class="container">

            <div class="intro-box bg-grey-100">
                <div class="text">
                    <h4 class="display-5-5 text-secondary font-weight-bold mb-4">Introduction</h4>
                    <p class="text-lead font-weight-normal text-grey-500 mb-0">
                        The purpose of this document is to describe the Company’s policies and commitment to the
                        detection
                        and prevention of any Money Laundering or Terrorist Financing activity within the products and
                        services it offers.
                    </p>
                </div>
            </div>

            <div class="content">
                <h2 class="display-3 font-weight-bold mb-4">Terms</h2>
                <p class="text-grey-500 mb-4 font16">
                    <strong>“Money Laundering”</strong> is the participation in any transaction that seeks to conceal or
                    disguise the nature
                    or origin of funds derived from illegal activities such as, but no limited to, fraud, corruption,
                    organized
                    crime or terrorism. Predicate offences for Money Laundering are defined by national law. The Money
                    Laundering process consists of three stages:
                </p>

                <p class="text-grey-500 mb-4 font16">
                    <strong>Stage 1: Placement.</strong> This stage refers to infusing cash delivered from any unlawful
                    activity to the
                    financial system. This can be done by
                </p>

                <ul>
                    <li>
                        <p class="text-grey-500 font16">
                            Physically depositing cash into banks and non-bank financial institutions such as currency
                            exchanges.
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            Converting cash into other financial instruments such as by purchasing monetary instruments
                            (travellers’ checks, payment orders) or
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            Using cash to purchase high-value goods that can be resold.
                        </p>
                        <p class="text-grey-500 font16">
                            Launderers often seek to deposit cash into banks in countries with fewer financial market
                            regulation
                            demands and then transfer these funds to banks in regulated environments, converting them
                            “clean”. A
                            frequent example of Placement is Smurfing - a formof Placement where the launderer makes
                            many small
                            cash deposits instead of a large one to evade local regulatory reporting requirements
                            applicable to cash
                            transactions.
                        </p>
                        <p class="text-grey-500 mb-4">
                            This stage refers to separating the proceeds of criminal activity from their source
                            through the use of layers of financial transactions such as multiple transfers of funds
                            among financial
                            institutions, early surrender of an annuity without regard to penalties, cash collateralized
                            loans, etc.
                            The layering aims to disguise the origin of the funds, disrupt any audit trail, and provide
                            anonymity.
                            Launderers want to move funds around, changing both the form of the funds and their location
                            in order
                            to make it more complicated for law enforcement authorities to trace “dirty” money.
                        </p>
                        <p class="text-grey-500 mb-4">
                            <strong>Stage 3: Integration:</strong> This stage refers to placing the laundered proceeds
                            back into the economy in
                            such a way that they re- enter and appear in the financial system as legitimate funds. This
                            Policy is
                            supported by a set of programs covering the implementation of the following areas:
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            The adoption of a risk-based approach.
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            Know Your Customer (KYC) Policy and Customer Due Anti-Money Laundering.
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            Customer activity monitoring
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            Record Keeping.
                        </p>
                    </li>
                </ul>

            </div>

            <div class="content mt-80">
                <h2 class="display-3 font-weight-bold mb-4">Measures</h2>
                <p class="text-grey-500 mb-4 font16">
                    The Company shall abide to the principles of Anti-Money Laundering and shall enforce any measures
                    to prevent any actions that aim or facilitate the process of legalizing of illegally gained funds
                </p>
                <p class="text-grey-500 mb-4 font16">
                    The Customer acknowledges that prevent of Money Laundering, the Company neither accepts nor
                    performs any payments in cash under any circumstances
                </p>
                <p class="text-grey-500 mb-4 font16">
                    In cases of an attempt to execute transactions which the Company suspects that are related to Money
                    Laundering or other criminal activity, it will proceed in accordance with the applicable law and
                    report
                    suspicious activity to regulating authority.
                </p>
                <p class="text-grey-500 mb-4 font16">
                    The Company reserves the right to suspend any Customer’s operation, which can be regarded as illegal
                    or may be related to Money Laundering in the opinion of its employees. The Company has the right,
                    in its discretion, to temporarily block the suspicious Customer account or terminate an existing
                    business
                    relationship with a customer
                </p>


            </div>

            <div class="content mt-80">
                <h2 class="display-3 font-weight-bold mb-4">Risk-based Approach</h2>
                <p class="text-grey-500 mb-4 font16">
                    The identification of Money Laundering risks involving of Customers and transactions allow the
                    Company to
                    determine and implement proportionate measures to control and mitigate these risks. The Company
                    separates
                    risk based on three categories:
                </p>

                <ul>
                    <li>
                        <p class="text-grey-500 font16">
                            <strong>Country:</strong> In conjunction with other risk factors, it provides useful
                            information as to potential money
                            laundering risks. Factors that may result in a determination that a country poses a
                            heightened risk
                            include:
                        </p>
                        <ul style="list-style-type: disc" class="my-4">
                            <li>
                                <p class="text-grey-500 font16">Countries subject to sanctions, embargoes, or similar
                                    measures.</p></li>
                            <li><p class="text-grey-500 font16"> Countries identified by the Financial Action Task Force
                                    (“FATF”) as noncooperative in the fight
                                    against money laundering or identified by credible sources as lacking appropriate
                                    money
                                    laundering laws and regulations</p></li>
                            <li><p class="text-grey-500 font16"> Countries identified by credible sources as providing
                                    funding or support for terrorist activities</p></li>
                        </ul>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            <strong>Customer:</strong> There is no universal consensus as to which Customers pose a high
                            risk, but the below
                            listed characteristics of Customers have been identified with potentially heightened money
                            laundering
                            risks:
                        </p>
                        <ul style="list-style-type: disc" class="my-4">
                            <li><p class="text-grey-500 font16">Armament manufacturers.</p></li>
                            <li><p class="text-grey-500 font16">Cash intensive business.</p></li>
                        </ul>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            <strong>Services:</strong> Determining the money laundering risks of services should include
                            a consideration of such
                            factors as services identified by regulators, governmental authorities or other credible
                            sources as being
                            potentially high risk for money laundering.

                        </p>
                    </li>
                </ul>

            </div>

            <div class="content mt-80">
                <h2 class="display-3 font-weight-bold mb-4"> Know your Customer and Customer due diligence</h2>
                <p class="text-grey-500 mb-4 font16">
                    The Company is an online operating brokerage company and therefore business relationships between
                    the company and its customers are not established on a face-to-face basis. For Customer
                    identification
                    purposes the Company uses electronic data brokers (linked with other in-house checks e.g.,
                    identifying
                    duplicate accounts, confirming ownership of bank accounts etc.) to verify the Customer’s identity.
                    This
                    will be used to determine and document the true identity of Customers to obtain background
                    information the intended nature of their business with the Company.
                </p>
                <p class="text-grey-500 mb-4 font16">
                    Upon the commencement of a business relationship between the two parties, the Company shall request
                    certain valid identification documentation from the Customer such as Passport details, Driving
                    license
                    details and proof of residence such as recent Utility bills (not older than six months). During the
                    business relationship between the two parties, the Company can request additional documentation or
                    information from Customer to verify for additional verification or updating existing verification
                </p>
                <p class="text-grey-500 mb-4 font16">
                    The Company shall obtain and document any additional Customer information, commensurate with
                    the assessment of the money laundering risk using a Risk Based Approach.
                </p>
                <p class="text-grey-500 mb-4 font16">
                    The Company shall identify whether the Customer is acting on behalf of another natural person or
                    legal
                    entity as trustee, nominee, or professional intermediary. In such case it is obligatory for the
                    Customer
                    to provide satisfactory evidence of the identity of any intermediaries and of the persons upon whose
                    behalf they are acting, as well as the nature of the trust arrangements in place
                </p>
                <p class="text-grey-500 mb-4 font16">
                    In all cases the Company shall apply due diligence measures in the following cases, in order to
                    comply
                    with the applicable laws/regulations.
                </p>

            </div>

            <div class="content mt-80">
                <h2 class="display-3 font-weight-bold mb-4">Customer activity monitoring</h2>
                <p class="text-grey-500 mb-4 font16">
                    The Company, in addition to conducting initial Customer due diligence, continues to monitor Customer
                    activity to identify and prevent any suspicious (or fraudulent) behaviour. The monitoring system that
                    was implemented relies on both automated monitoring and, where appropriate, manual monitoring of
                    transactions by the Company’s employees and outsourced service providers. A series of status fields
                    has been applied to Customer accounts indicating their profile within the system, which
                    assists automated monitoring.
                </p>
                <p class="text-grey-500 mb-4 font16">
                    The Company has implemented a regulatory and legally compliant suspicious activity reporting process
                    and procedure that will enable all employees to a report to the Money Laundering Reporting Officer
                    (MLRO) where they have reasonable grounds to suspect that a person is engaged in money laundering
                    or terrorist financing. This process includes the following requirements:
                </p>
                <ul>
                    <li>
                        <p class="text-grey-500 font16">
                            All employees shall be diligent in monitoring for any unusual or suspicious transactions/activity.
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            The reporting of suspicious transactions/activity must comply with the laws/regulations of the
                            respective jurisdiction.
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            The MLRO must be informed about all suspicious transaction/activity on a monthly basis at least.
                        </p>
                    </li>

                </ul>

            </div>

            <div class="content mt-80">
                <h2 class="display-3 font-weight-bold mb-4">Record keeping</h2>
                <p class="text-grey-500 mb-4 font16">
                    The Customer acknowledges that the Company shall keep records of:
                </p>
                <ul>
                    <li>
                        <p class="text-grey-500 font16">
                            All documents obtained for the purpose of Customer identification (KYC policy requirements);
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            All transaction data and information.
                        </p>
                    </li>
                    <li>
                        <p class="text-grey-500 font16">
                            Other information related to money laundering matters in accordance with the applicable anti- Money
                            Laundering laws/regulations. That includes files on suspicious activity reports, documentation of AML
                            account monitoring, etc.
                        </p>
                        <p class="text-grey-500 font16">
                            The Company shall keep all Customer records and/or trading and non-trading activity, current and/or
                            past and/or archived for a minimum period of five years after the termination of the business
                            relationship with the Customer and as per applicable legislative requirements.
                        </p>
                    </li>

                </ul>

            </div>
        </div>
    </section>
    



<?php include('footer.php') ?>
