<?php include('../header.php') ?>




    
    <section class="hero-mini-banner" style="
            background: url(../assets/img/forex-basics-hero-bg.png) no-repeat;
            background-size: cover;
            background-position: center;
            ">
        <div class="container">
            <div class="banner-content">
                <h1 class="text-white display-2 font-weight-bold mb-3">
                    Basic Forex market concepts
                </h1>
                <p class="text-white">
                    This forex beginner's tutorial will help you understand the fundamentals of Forex trading. Currency
                    pairings, trading terminology, leverage and much more.
                </p>
            </div>
        </div>
    </section>
    

    
    <section class="trading-1 theme-padding bg-grey-100">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="content-box text-md-left text-center content-limited-width">
                        <h2 class="display-3 font-weight-bold mb-4">
                            What is Currency Pair?
                        </h2>
                        <p class="text-grey-500 mb-0 text-lead">
                            Because forex involves the exchange of two currencies, all FX trading is done in pairs. The
                            base currency is the first currency in a pair, whereas the quote currency or counter
                            currency is the second. EURUSD, for example, is a currency pair that allows you to trade the
                            Euro against the US dollar. The base currency is EUR, which represents for Euro, and the
                            quote currency is USD, which stands for United States Dollar.
                        </p>
                        <img src="../assets/img/forex-basics-03.png" class="img-fluid mt-sm-5 mt-4" alt="" />
                    </div>
                </div>
                <div class="col-md-6 mt-md-0 mt-5 text-center text-md-right">
                    <img src="../assets/img/forex-basics-02.png" class="img-fluid" alt="" />
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="partner-3 partner-2 theme-padding">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6 order-md-2 order-1">
                    <div class="content mr-md-5 content-limited-width ml-md-auto">
                        <h2 class="display-3 font-weight-bold mb-4 text-secondary">Types of Currency Pairs</h2>
                        <p class="font-weight-normal text-lead text-grey-500">
                            Currency pairs are divided into three groups based on their characteristics in the market.
                        </p>
                        <ul class="pl-0 mt-3 text-secondary font-weight-bold">
                            <li>
                                Major currency pairs
                            </li>
                            <li>
                                Minor currency pairs and crosses
                            </li>
                            <li>
                                Exotic currency pairs
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 mt-md-0 mt-5 order-md-1 order-2">
                    <div class="img-box text-md-left text-center">
                        <img src="../assets/img/forex-basics-04.png" class="img-fluid max-w-500" alt="" />
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="trading-participants-section theme-padding" style="
        background: url(../assets/img/learn-forex-4-bg.png) no-repeat;
        background-size: cover;
        background-position: center;
        ">
        <div class="container">
            <div class="title text-center limited-width">
                <h2 class="font-weight-bold text-white display-3 mb-0">Major Currency Pairs</h2>
                <p class="text-white">Currency pairs are divided into three groups based on their characteristics in the
                    market.</p>
            </div>
            <div class="currency-pair-table">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>Majors</th>
                            <th>Currency Pair</th>
                            <th>Nickname</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>EUR/USD</td>
                            <td>Euro against the US dollar</td>
                            <td>Euro</td>
                        </tr>
                        <tr>
                            <td>USD/JPY</td>
                            <td>US Dollar against the Japanese yen</td>
                            <td>Gopher</td>
                        </tr>
                        <tr>
                            <td>GBP/USD</td>
                            <td>British Pound against the US dollar</td>
                            <td>Cable or Sterlingd</td>
                        </tr>
                        <tr>
                            <td>USD/CHF</td>
                            <td>US Dollar against the Swiss franc</td>
                            <td>Swissie</td>
                        </tr>
                        <tr>
                            <td>USD/CAD</td>
                            <td>US Dollar against the Canadian dollar</td>
                            <td>Loonie</td>
                        </tr>
                        <tr>
                            <td>AUD/USD</td>
                            <td>Australian dollar against the US dollar</td>
                            <td>Aussie</td>
                        </tr>
                        <tr>
                            <td>NZD/USD</td>
                            <td>New Zealand dollar against the US dollar</td>
                            <td>Kiwi</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="trading-participants-section theme-padding" style="
        background: url(../assets/img/learn-forex-4-bg.png) no-repeat;
        background-size: cover;
        background-position: center;
        ">
        <div class="container">
            <div class="title text-center limited-width">
                <h2 class="font-weight-bold text-white display-3 mb-0">Minor/Crosses Currency Pairs</h2>
                <p class="text-white">Currency pairs that do not involve the US dollar are called Crosses or minor
                    currency pairs. They are
                    riskier to trade than majors.</p>
            </div>
            <div class="currency-pair-table">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>Minors</th>
                            <th>Currency Pair</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>EUR/GBP</td>
                            <td>Euro against British Pound</td>
                        </tr>
                        <tr>
                            <td>EUR/JPY</td>
                            <td>Euro against Japanese Yen</td>
                        </tr>
                        <tr>
                            <td>EUR/CHF</td>
                            <td>Euro against Swiss Franc</td>
                        </tr>
                        <tr>
                            <td>EUR/CAD</td>
                            <td>Euro against Canadian Dollar</td>
                        </tr>
                        <tr>
                            <td>AUD/JPY</td>
                            <td>Australian Dollar against Japanese Yen</td>
                        </tr>
                        <tr>
                            <td>AUD/NZD</td>
                            <td>Australian Dollar against New Zealand Dollar</td>
                        </tr>
                        <tr>
                            <td>GBP/JPY</td>
                            <td>British Pound against Japanese Yen</td>
                        </tr>

                        <tr>
                            <td>NZD/JPY</td>
                            <td>New Zealand Dollar against Japanese Yen</td>
                        </tr>
                        <tr>
                            <td>NZD/CHF</td>
                            <td>New Zealand Dollar against Swiss Franc</td>
                        </tr>
                        <tr>
                            <td>GBP/AUD</td>
                            <td>British Pound against Australian Dollar</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="trading-participants-section theme-padding" style="
        background: url(../assets/img/learn-forex-4-bg.png) no-repeat;
        background-size: cover;
        background-position: center;
        ">
        <div class="container">
            <div class="title text-center limited-width">
                <h2 class="font-weight-bold text-white display-3 mb-0">Exotics Currency Pairs</h2>
                <p class="text-white">Exotics are the group of currency pairs that involve at least one currency from a
                    small country or
                    emerging economy. Exotics associated with higher risk as they are known as susceptible pairs to
                    sudden economic and political changes.</p>
            </div>
            <div class="currency-pair-table">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>Exotics</th>
                            <th>Currency Pair</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>EUR/TRY</td>
                            <td>Euro against Turkish Lira</td>
                        </tr>
                        <tr>
                            <td>USD/TRY</td>
                            <td>US Dollar against Turkish Lira</td>
                        </tr>
                        <tr>
                            <td>USD/INR</td>
                            <td>US dollar against the Indian rupee</td>
                        </tr>
                        <tr>
                            <td>USD/NOK</td>
                            <td>US Dollar against Norwegian Krone</td>
                        </tr>
                        <tr>
                            <td>USD/DKK</td>
                            <td>US Dollar against Danish Krone</td>
                        </tr>
                        <tr>
                            <td>USD/ZAR</td>
                            <td>US Dollar against South African Rand</td>
                        </tr>
                        <tr>
                            <td>USD/THB</td>
                            <td>US Dollar against Thailand Baht</td>
                        </tr>

                        <tr>
                            <td>USD/SGD</td>
                            <td>US Dollar against Singapore Dollar</td>
                        </tr>
                        <tr>
                            <td>USD/SEK</td>
                            <td>US Dollar against Swedish Krona</td>
                        </tr>
                        <tr>
                            <td>USD/MXN</td>
                            <td>US Dollar against Mexican Peso</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="trading-1 theme-padding bg-grey-100">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="content-box text-md-left text-center">
                        <h2 class="display-3 font-weight-bold mb-4">
                            What is CFD?
                        </h2>
                        <p class="text-grey-500 mb-5 text-lead">
                            CFD is short for Contract for Difference and refers to the type of trading instruments
                            obtaining their value from an underlying asset. CFDs are popular speculative tools that
                            allow traders to participate in asset price movements without fully owning the underlying
                            asset.
                        </p>
                        <h4 class="font-weight-bold mb-4" style="font-size: 2.5rem !important;">
                            Types of CFDs
                        </h4>
                        <p class="text-grey-500 mb-5 text-lead">
                            CFDs are categorized into five groups depending on their underlying asset as follows:
                        </p>
                        <ul class="mb-4" style="font-size: 2.1rem !important;">
                            <li>Forex like EUR/USD, GBP/JPY, etc.</li>
                            <li>CFDs on commodities like spot metals, gas, and oil.</li>
                            <li>CFDs on cryptocurrencies like bitcoin, ethereum, and more.</li>
                            <li>CFDs on indices like S&P500, DAX30, and more.</li>
                            <li>CFDs on shares like Apple, Microsoft, Tesla, and more.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="partner-3 theme-padding ">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="content-box text-md-left text-center">
                        <h2 class="display-3 font-weight-bold mb-4">
                            Why trade CFDs
                        </h2>
                        <p class="text-grey-500 mb-5 text-lead">
                            These exceptional features of CFDs make them very popular for trading:
                        </p>
                        <h4 class="font-weight-bold mb-4" style="font-size: 2.5rem !important;">
                            Access to a huge range of markets
                        </h4>
                        <p class="text-grey-500 mb-5 text-lead">
                            With CFDs trading, you can participate in many different markets like equities, commodities,
                            spot metals, cryptocurrencies, and forex on one trading platform without having to own
                            physical assets.
                        </p>
                        <h4 class="font-weight-bold mb-4" style="font-size: 2.5rem !important;">
                            Trade on both market directions
                        </h4>
                        <p class="text-grey-500 mb-5 text-lead">
                            CFDs can provide very flexible trading opportunities as they can be traded on both rising
                            and falling markets. If you expect the value of an underlying asset to grow, you can buy a
                            certain number of CFD on that asset or go long. Vice versa, if you think the asset price
                            will crash, you can sell its CFD or go short. So, CFDs give you an opportunity to profits in
                            both directions.
                        </p>
                        <h4 class="font-weight-bold mb-4" style="font-size: 2.5rem !important;">
                            Trade small contract sizes
                        </h4>
                        <p class="text-grey-500 mb-5 text-lead">
                            CFDs trading is possible on a fraction of the underlying asset, which means you can enter
                            the market with smaller amounts of money. So, CFD trading is cheaper than trading the
                            underlying asset while it provides you with the same opportunities to profit.
                        </p>
                        <h4 class="font-weight-bold mb-4" style="font-size: 2.5rem !important;">
                            Margin trading
                        </h4>
                        <p class="text-grey-500 mb-5 text-lead">
                            You can use leverage when trading CFDs. Leverage increases exposure on a trade for a certain
                            amount of capital that can magnify profits. However, the leverage also increases the
                            trader's risk.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="why-choose theme-padding type-2">
        <div class="container">
            <div class="title text-center limited-width">
                <h2 class="font-weight-bold display-3 mb-3 ab-heading">Why Choose Wizense?</h2>
                <p class="font-weight-light text-grey-500 text-lead">
                    Wizense is an internationally trusted representative. Our features eases the trading experience of our
                    clients.
                </p>
            </div>
            <div class="content-box">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                24/7 Customer support
                            </h5>
                            <p class="text-grey-500">
                                Our customer support experts are available for you 24x7.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                Ease of Transactions
                            </h5>
                            <p class="text-grey-500">
                                Experience uninterrupted quick deposits & withdrawals.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                Safety of Funds
                            </h5>
                            <p class="text-grey-500">
                                Maximum protection and data security with negative balance
                                protection.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="box text-center">
                            <h5 class="font-weight-bold mb-3 text-lead-2">
                                Super- Fast trading execution
                            </h5>
                            <p class="text-grey-500">
                                Trade with fast execution, low spreads & handy tools.
                            </p>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
    



<?php include('../footer.php') ?>
